DELETE FROM PERSON_ROLE;
DELETE FROM METADATA_DESCRIPTOR;
DELETE FROM MEDIA_ITEM;
DELETE FROM MUSIC_ALBUM;
DELETE FROM SERIES;
DELETE FROM PERSON;
DELETE FROM GENRE;
DELETE FROM FOLDER;
DELETE FROM COVER_IMAGE;

ALTER TABLE MEDIA_ITEM ADD COLUMN FILE_PATH VARCHAR(4096) NOT NULL DEFAULT '';
ALTER TABLE MEDIA_ITEM ADD COLUMN LC_FILE_PATH GENERATED ALWAYS AS (LOWER(FILE_PATH));
CREATE INDEX IDX_MEDIA_ITEM_FILEPATH ON MEDIA_ITEM (FILE_PATH);
CREATE INDEX IDX_MEDIA_ITEM_LCFILEPATH ON MEDIA_ITEM (LC_FILE_PATH);

ALTER TABLE MEDIA_ITEM ADD COLUMN ONLINE_IDENTIFIERS VARCHAR(256);
ALTER TABLE MEDIA_ITEM ADD COLUMN REPOSITORY_ID INT CONSTRAINT mi_repository_foreign_key REFERENCES REPOSITORY;
UPDATE MEDIA_ITEM mi SET mi.REPOSITORY_ID = (SELECT REPOSITORY_ID FROM FOLDER WHERE ID =mi.FOLDER_ID);
ALTER TABLE MEDIA_ITEM ALTER COLUMN REPOSITORY_ID NOT NULL;
ALTER TABLE MEDIA_ITEM ADD COLUMN SAR VARCHAR(20);
ALTER TABLE MEDIA_ITEM ADD COLUMN SUBSAMPLING VARCHAR(15);
ALTER TABLE MEDIA_ITEM ADD COLUMN MKV_HEADER_COMPRESSION SMALLINT;

ALTER TABLE RENDERER ADD COLUMN ENABLED SMALLINT NOT NULL DEFAULT 1;

UPDATE REPOSITORY SET LAST_SCANNED = NULL;

CREATE TABLE PLAYLIST (ID INT NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1) CONSTRAINT playlist_pk PRIMARY KEY,
             FILE_TYPES VARCHAR(20),
             TITLE VARCHAR(128) NOT NULL,             
             FILE_PATH VARCHAR(4096) NOT NULL,
             DATE_UPDATED TIMESTAMP,
             REPOSITORY_ID INT NOT NULL CONSTRAINT pl_rep_foreign_key REFERENCES REPOSITORY,
             ALL_ITEMS_FOUND SMALLINT NOT NULL DEFAULT 0);
  
CREATE TABLE PLAYLIST_ITEM (ID INT NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1) CONSTRAINT playlist_item_pk PRIMARY KEY,
             ITEM_ORDER INT NOT NULL DEFAULT 1,
             PLAYLIST_ID INT NOT NULL CONSTRAINT pi_playlist_foreign_key REFERENCES PLAYLIST,
             MEDIA_ITEM_ID INT CONSTRAINT pi_item_foreign_key REFERENCES MEDIA_ITEM);  

CREATE TABLE ACCESS_GROUP (ID INT NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1) CONSTRAINT access_group_pk PRIMARY KEY,
             NAME VARCHAR(128) NOT NULL); 
             
INSERT INTO ACCESS_GROUP (NAME) VALUES ('No_Restriction');
INSERT INTO ACCESS_GROUP (NAME) VALUES ('Limited_Access');
ALTER TABLE RENDERER ADD COLUMN ACCESS_GROUP_ID INT NOT NULL DEFAULT 1 CONSTRAINT rend_agroup_foreign_key REFERENCES ACCESS_GROUP;

CREATE TABLE REPOSITORY_ACCESS_GROUP (ID INT NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1) CONSTRAINT repo_access_group_pk PRIMARY KEY,
             REPOSITORY_ID INT NOT NULL CONSTRAINT rap_repository_foreign_key REFERENCES REPOSITORY,
             ACCESS_GROUP_ID INT NOT NULL CONSTRAINT rap_agroup_foreign_key REFERENCES ACCESS_GROUP);

CREATE TABLE ONLINE_REPOSITORY_ACCESS_GROUP (ID INT NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1) CONSTRAINT orepo_access_group_pk PRIMARY KEY,
             ONLINE_REPOSITORY_ID INT NOT NULL CONSTRAINT orap_repository_foreign_key REFERENCES ONLINE_REPOSITORY,
             ACCESS_GROUP_ID INT NOT NULL CONSTRAINT orap_agroup_foreign_key REFERENCES ACCESS_GROUP);
             
INSERT INTO REPOSITORY_ACCESS_GROUP (REPOSITORY_ID, ACCESS_GROUP_ID) SELECT ID, 1 FROM REPOSITORY;           
INSERT INTO ONLINE_REPOSITORY_ACCESS_GROUP (ONLINE_REPOSITORY_ID, ACCESS_GROUP_ID) SELECT ID, 1 FROM ONLINE_REPOSITORY;           

UPDATE RENDERER SET PROFILE_ID='sony2009' WHERE PROFILE_ID='21';
UPDATE RENDERER SET PROFILE_ID='sony2010' WHERE PROFILE_ID='19';
UPDATE RENDERER SET PROFILE_ID='sony2011' WHERE PROFILE_ID='9';
UPDATE RENDERER SET PROFILE_ID='viera2010' WHERE PROFILE_ID='12';

INSERT INTO DB_SCHEMA_VERSION(VER_MAJ,VER_MIN,SCRIPT_FILE) VALUES (1,0,'script-1.0.sql');    
