ALTER TABLE MUSIC_ALBUM DROP COLUMN ALBUM_ARTIST;
ALTER TABLE PERSON_ROLE ADD COLUMN MUSIC_ALBUM_ID INT CONSTRAINT pr_album_foreign_key REFERENCES MUSIC_ALBUM ON DELETE CASCADE;
ALTER TABLE PERSON_ROLE ALTER COLUMN MEDIA_ITEM_ID NULL;
CREATE INDEX IDX_PERSON_ROLE_ROLE_TYPE_ALBUM ON PERSON_ROLE (ROLE_TYPE,MUSIC_ALBUM_ID);
CREATE INDEX IDX_PERSON_ROLE_PERSON_MEDIA_ITEM ON PERSON_ROLE (PERSON_ID,MEDIA_ITEM_ID);

ALTER TABLE PERSON ADD COLUMN INITIAL CHAR(1);
UPDATE PERSON SET INITIAL = UPPER(SUBSTR(SORT_NAME,1,1));
ALTER TABLE PERSON ALTER COLUMN INITIAL NOT NULL;
CREATE INDEX IDX_PERSON_INITIAL ON PERSON (INITIAL);
CREATE INDEX IDX_PERSON_NAME ON PERSON (NAME);

UPDATE MEDIA_ITEM SET DIRTY = 1;
UPDATE REPOSITORY SET LAST_SCANNED = NULL;

CREATE TABLE ONLINE_REPOSITORY (ID INT NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1) CONSTRAINT online_source_pk PRIMARY KEY,
             REPO_TYPE VARCHAR(32) NOT NULL,
             FILE_TYPE VARCHAR(5) NOT NULL,
             URL VARCHAR(4096) NOT NULL,             
             THUMBNAIL_URL VARCHAR(4096));             

CREATE INDEX IDX_MEDIA_ITEM_FILENAME ON MEDIA_ITEM (FILE_NAME);             

INSERT INTO DB_SCHEMA_VERSION(VER_MAJ,VER_MIN,SCRIPT_FILE) VALUES (0,8,'script-0.6.sql');    
