ALTER TABLE ONLINE_REPOSITORY ADD COLUMN NAME VARCHAR(256);
ALTER TABLE ONLINE_REPOSITORY ADD COLUMN ENABLED SMALLINT NOT NULL DEFAULT 1;
UPDATE ONLINE_REPOSITORY SET ENABLED = 1;

ALTER TABLE MEDIA_ITEM ADD COLUMN FTYP VARCHAR(10);

ALTER TABLE RENDERER ADD COLUMN PROFILE_FORCED SMALLINT NOT NULL DEFAULT 0;
                        
UPDATE MEDIA_ITEM SET DIRTY = 1 WHERE FILE_TYPE = 'VIDEO';
UPDATE REPOSITORY SET LAST_SCANNED = NULL WHERE FILE_TYPES LIKE '%VIDEO%';

UPDATE RENDERER SET PROFILE_ID = '10' WHERE PROFILE_ID = '20';
UPDATE RENDERER SET PROFILE_ID = '99' WHERE PROFILE_ID = '9';
UPDATE RENDERER SET PROFILE_ID = '9' WHERE PROFILE_ID = '19';
UPDATE RENDERER SET PROFILE_ID = '19' WHERE PROFILE_ID = '99';
     
ALTER TABLE FOLDER DROP CONSTRAINT parent_folder_foreign_key;
ALTER TABLE FOLDER DROP CONSTRAINT repository_foreign_key;
ALTER TABLE FOLDER ADD CONSTRAINT parent_folder_foreign_key FOREIGN KEY (PARENT_FOLDER_ID) REFERENCES FOLDER;
ALTER TABLE FOLDER ADD CONSTRAINT repository_foreign_key FOREIGN KEY (REPOSITORY_ID) REFERENCES REPOSITORY;
ALTER TABLE MEDIA_ITEM DROP CONSTRAINT mi_genre_foreign_key;
ALTER TABLE MEDIA_ITEM DROP CONSTRAINT mi_folder_foreign_key;
ALTER TABLE MEDIA_ITEM DROP CONSTRAINT mi_music_album_foreign_key;
ALTER TABLE MEDIA_ITEM DROP CONSTRAINT mi_series_foreign_key;
ALTER TABLE MEDIA_ITEM DROP CONSTRAINT mi_cover_image_foreign_key;
ALTER TABLE MEDIA_ITEM ADD CONSTRAINT mi_genre_foreign_key FOREIGN KEY (GENRE_ID) REFERENCES GENRE;
ALTER TABLE MEDIA_ITEM ADD CONSTRAINT mi_folder_foreign_key FOREIGN KEY (FOLDER_ID) REFERENCES FOLDER;
ALTER TABLE MEDIA_ITEM ADD CONSTRAINT mi_music_album_foreign_key FOREIGN KEY (ALBUM_ID) REFERENCES MUSIC_ALBUM;
ALTER TABLE MEDIA_ITEM ADD CONSTRAINT mi_series_foreign_key FOREIGN KEY (SERIES_ID) REFERENCES SERIES;
ALTER TABLE MEDIA_ITEM ADD CONSTRAINT mi_cover_image_foreign_key FOREIGN KEY (COVER_IMAGE_ID) REFERENCES COVER_IMAGE;
ALTER TABLE PERSON_ROLE DROP CONSTRAINT pr_person_foreign_key;             
ALTER TABLE PERSON_ROLE DROP CONSTRAINT pr_item_foreign_key;    
ALTER TABLE PERSON_ROLE DROP CONSTRAINT pr_album_foreign_key;  
ALTER TABLE PERSON_ROLE ADD CONSTRAINT pr_person_foreign_key FOREIGN KEY (PERSON_ID) REFERENCES PERSON;
ALTER TABLE PERSON_ROLE ADD CONSTRAINT pr_item_foreign_key FOREIGN KEY (MEDIA_ITEM_ID) REFERENCES MEDIA_ITEM;
ALTER TABLE PERSON_ROLE ADD CONSTRAINT pr_album_foreign_key FOREIGN KEY (MUSIC_ALBUM_ID) REFERENCES MUSIC_ALBUM;
  
INSERT INTO DB_SCHEMA_VERSION(VER_MAJ,VER_MIN,SCRIPT_FILE) VALUES (0,9,'script-0.6.1.sql');    
