CREATE TABLE RENDERER (UUID VARCHAR(64) NOT NULL CONSTRAINT renderer_pk PRIMARY KEY,
			 NAME VARCHAR(128),			 
			 IP_ADDRESS VARCHAR(15) NOT NULL,			 
			 PROFILE_ID VARCHAR(10),
			 MANUALLY_ADDED SMALLINT NOT NULL DEFAULT 0);

DELETE FROM config where name = 'profile_id';

ALTER TABLE MUSIC_ALBUM ALTER SORT_TITLE SET DATA TYPE VARCHAR(256);

ALTER TABLE REPOSITORY ADD COLUMN SCAN_FOR_UPDATES SMALLINT NOT NULL DEFAULT 1;
ALTER TABLE REPOSITORY ADD COLUMN LAST_SCANNED TIMESTAMP;

ALTER TABLE MEDIA_ITEM ADD COLUMN AUDIO_BITRATE INT;
ALTER TABLE MEDIA_ITEM ADD COLUMN VIDEO_STREAM_INDEX INT;
ALTER TABLE MEDIA_ITEM ADD COLUMN AUDIO_STREAM_INDEX INT;

UPDATE REPOSITORY SET LAST_SCANNED = CURRENT_TIMESTAMP;
UPDATE REPOSITORY SET SCAN_FOR_UPDATES = 1;

ALTER TABLE CONFIG ALTER VALUE SET DATA TYPE VARCHAR(1024);

UPDATE MEDIA_ITEM SET AUDIO_BITRATE = BITRATE WHERE FILE_TYPE='AUDIO';
UPDATE MEDIA_ITEM SET BITRATE = NULL WHERE FILE_TYPE='AUDIO';

UPDATE MEDIA_ITEM SET DIRTY = 1 WHERE FILE_TYPE='VIDEO';

INSERT INTO DB_SCHEMA_VERSION(VER_MAJ,VER_MIN,SCRIPT_FILE) VALUES (0,6,'script-0.5.sql');	
