/**
 * clean library data
 */
DELETE FROM PERSON_ROLE;
DELETE FROM METADATA_DESCRIPTOR;
DELETE FROM MEDIA_ITEM;
DELETE FROM SERIES;
DELETE FROM COVER_IMAGE;
DELETE FROM FOLDER;
DELETE FROM GENRE;
DELETE FROM MUSIC_ALBUM;
DELETE FROM PERSON;

/*
 * add indexes
 */
CREATE INDEX IDX_METADATA_DESCRIPTOR_TYPE_ITEM ON METADATA_DESCRIPTOR (EXTRACTOR_TYPE,MEDIA_ITEM_ID);

/*
 * update media item table
 */
ALTER TABLE MEDIA_ITEM ADD CONTENT_TYPE VARCHAR(10);
ALTER TABLE MEDIA_ITEM ADD COLUMN CONTAINER VARCHAR(30);
ALTER TABLE MEDIA_ITEM ADD COLUMN ACODEC VARCHAR(30);
ALTER TABLE MEDIA_ITEM ADD COLUMN VCODEC VARCHAR(30);
ALTER TABLE MEDIA_ITEM ADD COLUMN FPS REAL;
ALTER TABLE MEDIA_ITEM ADD COLUMN ROTATION SMALLINT;
ALTER TABLE MEDIA_ITEM DROP COLUMN FORMAT_PROFILE;

CREATE INDEX IDX_MEDIA_ITEM_CONTENT_TYPE ON MEDIA_ITEM (CONTENT_TYPE);


INSERT INTO DB_SCHEMA_VERSION(VER_MAJ,VER_MIN,SCRIPT_FILE) VALUES (0,5,'script-0.4.sql');	
