CREATE TABLE DB_SCHEMA_VERSION (ID SMALLINT NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1) CONSTRAINT db_schema_version_pk PRIMARY KEY,
								VER_MAJ SMALLINT NOT NULL,
								VER_MIN SMALLINT NOT NULL,
								SCRIPT_FILE VARCHAR(32) NOT NULL);
								
CREATE TABLE REPOSITORY (ID INT NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1) CONSTRAINT repository_pk PRIMARY KEY,
						 FOLDER VARCHAR(1024) NOT NULL,
						 FILE_TYPES VARCHAR(128) );

CREATE TABLE MUSIC_ALBUM (ID INT NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1) CONSTRAINT music_album_pk PRIMARY KEY,
			 TITLE VARCHAR(128) NOT NULL,
			 SORT_TITLE VARCHAR(128) NOT NULL,
			 ALBUM_ARTIST VARCHAR(128));		
			 
CREATE TABLE SERIES (ID INT NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1) CONSTRAINT series_pk PRIMARY KEY,
			 TITLE VARCHAR(128) NOT NULL,
			 SORT_TITLE VARCHAR(128) NOT NULL);		
			 
CREATE TABLE GENRE (ID INT NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1) CONSTRAINT genre_pk PRIMARY KEY,
			 NAME VARCHAR(128) NOT NULL);
			 
CREATE TABLE FOLDER (ID INT NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1) CONSTRAINT folder_pk PRIMARY KEY,
			 NAME VARCHAR(128) NOT NULL,
			 PARENT_FOLDER_ID INT CONSTRAINT parent_folder_foreign_key REFERENCES FOLDER ON DELETE CASCADE,
			 REPOSITORY_ID INT NOT NULL CONSTRAINT repository_foreign_key REFERENCES REPOSITORY ON DELETE CASCADE);			 
			 
CREATE TABLE PERSON (ID INT NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1) CONSTRAINT person_pk PRIMARY KEY,
			 NAME VARCHAR(128) NOT NULL,
			 SORT_NAME VARCHAR(128) NOT NULL);
			 
CREATE TABLE COVER_IMAGE(ID INT NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1) CONSTRAINT covenr_image_pk PRIMARY KEY,
			 IMAGE_DATA BLOB(10000000) NOT NULL,
			 MIME_TYPE VARCHAR(15) NOT NULL,
			 WIDTH INT,
			 HEIGHT INT);

CREATE TABLE METADATA_EXTRACTOR_CONFIG (ID INT NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1) CONSTRAINT metadata_extractor_pk PRIMARY KEY,
			 MEDIA_FILE_TYPE VARCHAR(5) NOT NULL,
			 EXTRACTOR_TYPE VARCHAR(32) NOT NULL,
			 ORDER_NUMBER SMALLINT NOT NULL DEFAULT 1);
			 
CREATE UNIQUE INDEX IDX_METADATA_EXTRACTOR_CONFIG_UNIQUE ON METADATA_EXTRACTOR_CONFIG ( MEDIA_FILE_TYPE, EXTRACTOR_TYPE );
			 
CREATE TABLE MEDIA_ITEM (ID INT NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1) CONSTRAINT media_item_pk PRIMARY KEY,
			 FILE_TYPE VARCHAR(5) NOT NULL,
			 FORMAT_PROFILE VARCHAR(30) NOT NULL,
			 DIRTY SMALLINT NOT NULL DEFAULT 0,
			 TITLE VARCHAR(128) NOT NULL,		
			 SORT_TITLE VARCHAR(128) NOT NULL,
			 ORDER_NUMBER SMALLINT,
			 SEASON_NUMBER SMALLINT,
			 DURATION INT,
			 RELEASE_YEAR INT,
			 RATING VARCHAR(10),
			 CREATION_DATE TIMESTAMP NOT NULL,
			 LAST_VIEWED_DATE TIMESTAMP,
			 NUMBER_VIEWED INT DEFAULT 0,
			 FILE_SIZE BIGINT NOT NULL,
			 FILE_NAME VARCHAR(128) NOT NULL,
			 DESCRIPTION VARCHAR(1024),
			 BITRATE INT,
			 CHANNELS INT,
			 SAMPLE_FREQUENCY INT,
			 WIDTH INT,
			 HEIGHT INT,
			 COLOR_DEPTH INT,
			 GENRE_ID INT CONSTRAINT mi_genre_foreign_key REFERENCES GENRE ON DELETE CASCADE,
			 FOLDER_ID INT NOT NULL CONSTRAINT mi_folder_foreign_key REFERENCES FOLDER ON DELETE CASCADE,
			 ALBUM_ID INT CONSTRAINT mi_music_album_foreign_key REFERENCES MUSIC_ALBUM ON DELETE CASCADE,
			 SERIES_ID INT CONSTRAINT mi_series_foreign_key REFERENCES SERIES ON DELETE CASCADE,
			 COVER_IMAGE_ID INT CONSTRAINT mi_cover_image_foreign_key REFERENCES COVER_IMAGE ON DELETE CASCADE,
			 DATE_ADDED TIMESTAMP DEFAULT CURRENT TIMESTAMP
			 );		
			 
CREATE INDEX IDX_MEDIA_ITEM_FILE_TYPE ON MEDIA_ITEM (FILE_TYPE);
			 
CREATE TABLE PERSON_ROLE (ID INT NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1) CONSTRAINT person_role_pk PRIMARY KEY,
			 ROLE_TYPE VARCHAR(64) NOT NULL,
			 PERSON_ID INT NOT NULL CONSTRAINT pr_person_foreign_key REFERENCES PERSON ON DELETE CASCADE,
			 MEDIA_ITEM_ID INT NOT NULL CONSTRAINT pr_item_foreign_key REFERENCES MEDIA_ITEM ON DELETE CASCADE);
			 
			 
CREATE TABLE METADATA_DESCRIPTOR (ID INT NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1) CONSTRAINT metadata_descriptor_pk PRIMARY KEY,
			 EXTRACTOR_TYPE VARCHAR(32) NOT NULL,
			 DATE_UPDATED TIMESTAMP NOT NULL,
			 IDENTIFIER VARCHAR(512),
			 MEDIA_ITEM_ID INT NOT NULL CONSTRAINT md_item_foreign_key REFERENCES MEDIA_ITEM);
			 
CREATE INDEX IDX_METADATA_DESCRIPTOR_EXTRACTOR_TYPE ON METADATA_DESCRIPTOR (EXTRACTOR_TYPE);

CREATE TABLE CONFIG (ID INT NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1) CONSTRAINT config_pk PRIMARY KEY,
			 NAME VARCHAR(64) NOT NULL,
			 VALUE VARCHAR(256));	
			 
/*
 * insert data
 */
			 
INSERT INTO DB_SCHEMA_VERSION(VER_MAJ,VER_MIN,SCRIPT_FILE) VALUES (0,1,'script-0.1.sql');	

INSERT INTO METADATA_EXTRACTOR_CONFIG ( MEDIA_FILE_TYPE, EXTRACTOR_TYPE, ORDER_NUMBER ) VALUES ('AUDIO', 'COVER_IMAGE_IN_FOLDER', 10);
INSERT INTO METADATA_EXTRACTOR_CONFIG ( MEDIA_FILE_TYPE, EXTRACTOR_TYPE, ORDER_NUMBER ) VALUES ('VIDEO', 'COVER_IMAGE_IN_FOLDER', 10);
INSERT INTO METADATA_EXTRACTOR_CONFIG ( MEDIA_FILE_TYPE, EXTRACTOR_TYPE, ORDER_NUMBER ) VALUES ('VIDEO', 'ONLINE_VIDEO_SOURCES', 1);