/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.serviio.util.FileUtils;

public class ZipUtils {
    public static InputStream unZipSingleFile(InputStream is) throws IOException {
        ZipInputStream zis = new ZipInputStream(is);
        ZipEntry entry = zis.getNextEntry();
        if (entry == null) {
            throw new IOException("Invalid zip file");
        }
        byte[] unpackedFile = FileUtils.readFileBytes(zis);
        return new ByteArrayInputStream(unpackedFile);
    }

    public static InputStream unGzipSingleFile(InputStream is) throws IOException {
        GZIPInputStream zis = new GZIPInputStream(is);
        byte[] unpackedFile = FileUtils.readFileBytes(zis);
        return new ByteArrayInputStream(unpackedFile);
    }
}

