/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.util;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XmlUtils {
    private static final Logger log = LoggerFactory.getLogger((String)XmlUtils.class.getName());
    private static final Pattern XML_FIX = Pattern.compile("&(?!(?:[a-z]+|#[0-9]+|#x[0-9a-f]+);)", 2);

    public static String objectToXMLType(Object object) {
        if (object != null) {
            if (object instanceof String) {
                return (String)object;
            }
            if (object instanceof Integer) {
                return ((Integer)object).toString();
            }
            return object.toString();
        }
        return null;
    }

    public static String getStringFromDocument(Document doc, boolean omitXmlDeclaration) {
        DOMSource domSource = new DOMSource(doc);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            Transformer transformer = tf.newTransformer();
            if (omitXmlDeclaration) {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            transformer.transform(domSource, result);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        return writer.toString();
    }

    public static boolean validateXML(String xmlId, URL schemaURL, String xml) {
        StreamSource xmlFile = new StreamSource(new StringReader(xml));
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            Schema schema = schemaFactory.newSchema(schemaURL);
            Validator validator = schema.newValidator();
            validator.validate(xmlFile);
            return true;
        }
        catch (SAXException e) {
            log.error(String.format("XML %s didn't pass validation, reason: %s", xmlId, e.getLocalizedMessage()));
            return false;
        }
        catch (IOException e) {
            log.error(String.format("Cannot validate XML %s, reason: %s", xmlId, e.getMessage()));
            return false;
        }
    }

    public static String decodeXml(String decodedXml) {
        String result = decodedXml.replaceAll("&lt;", "<");
        result = result.replaceAll("&gt;", ">");
        return result;
    }

    public static String normalizeXML(String xml) {
        if (xml != null) {
            return XML_FIX.matcher(xml).replaceAll("&amp;");
        }
        return null;
    }
}

