/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XPathUtil {
    private static XPathFactory factory = XPathFactory.newInstance();

    public static synchronized Node getRootNode(InputStream xmlDocument) throws XPathExpressionException {
        return XPathUtil.getNode(xmlDocument, "/");
    }

    public static synchronized Node getRootNode(String xmlDocument) throws XPathExpressionException {
        return XPathUtil.getNode(xmlDocument, "/");
    }

    public static synchronized NodeList getNodeSet(InputStream xmlDocument, String path) throws XPathExpressionException {
        NodeList result = null;
        if (xmlDocument.markSupported()) {
            try {
                xmlDocument.reset();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        InputSource source = new InputSource(xmlDocument);
        source.setSystemId(UUID.randomUUID().toString());
        XPath xpath = factory.newXPath();
        result = (NodeList)xpath.evaluate(path, source, XPathConstants.NODESET);
        return result;
    }

    public static synchronized NodeList getNodeSet(Node context, String path) throws XPathExpressionException {
        return XPathUtil.getNodeSet(context, path, null);
    }

    public static synchronized NodeList getNodeSet(Node context, String path, NamespaceContext namespaceContext) throws XPathExpressionException {
        NodeList result = null;
        XPath xpath = factory.newXPath();
        if (namespaceContext != null) {
            xpath.setNamespaceContext(namespaceContext);
        }
        result = (NodeList)xpath.evaluate(path, context, XPathConstants.NODESET);
        return result;
    }

    public static synchronized Node getNode(InputStream xmlDocument, String path) throws XPathExpressionException {
        Node result = null;
        if (xmlDocument.markSupported()) {
            try {
                xmlDocument.reset();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        InputSource source = new InputSource(xmlDocument);
        result = XPathUtil.evaluateXPath(source, path);
        return result;
    }

    public static synchronized Node getNode(String xmlDocument, String path) throws XPathExpressionException {
        Node result = null;
        InputSource source = new InputSource(new StringReader(xmlDocument));
        result = XPathUtil.evaluateXPath(source, path);
        return result;
    }

    public static synchronized Node getNode(Node context, String path) throws XPathExpressionException {
        return XPathUtil.getNode(context, path, null);
    }

    public static synchronized Node getNode(Node context, String path, NamespaceContext namespaceContext) throws XPathExpressionException {
        Node result = null;
        XPath xpath = factory.newXPath();
        if (namespaceContext != null) {
            xpath.setNamespaceContext(namespaceContext);
        }
        result = (Node)xpath.evaluate(path, context, XPathConstants.NODE);
        return result;
    }

    public static String getNodeValue(Node context, String path) throws XPathExpressionException {
        return XPathUtil.getNodeValue(context, path, null);
    }

    public static String getNodeValue(Node context, String path, NamespaceContext namespaceContext) throws XPathExpressionException {
        Node node = XPathUtil.getNode(context, path, namespaceContext);
        if (node != null) {
            return node.getTextContent();
        }
        return null;
    }

    public static List<Node> getListOfNodes(NodeList nodeList) {
        ArrayList<Node> result = new ArrayList<Node>();
        if (nodeList != null && nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                result.add(node);
            }
        }
        return result;
    }

    public static String getParseExceptionMessage(XPathExpressionException e) {
        return e.getMessage() != null ? e.getMessage() : (e.getCause() != null ? e.getCause().getMessage() : "Undefined");
    }

    private static synchronized Node evaluateXPath(InputSource sourceXML, String path) throws XPathExpressionException {
        sourceXML.setSystemId(UUID.randomUUID().toString());
        XPath xpath = factory.newXPath();
        return (Node)xpath.evaluate(path, sourceXML, XPathConstants.NODE);
    }
}

