/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.text.Normalizer;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.serviio.util.FileUtils;
import org.serviio.util.ObjectValidator;

public class StringUtils {
    public static final String UTF_8_ENCODING = "UTF-8";
    public static String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final Pattern articlesPattern = Pattern.compile("^(the|a)(\\s|\\.(?!\\s)|_)(?!&)", 2);

    public static String removeArticles(String value) {
        if (value != null) {
            value = value.replaceAll("'|\"", "");
            return articlesPattern.matcher(value).replaceFirst("");
        }
        return null;
    }

    public static String removeAccents(String value) {
        String result = Normalizer.normalize(value, Normalizer.Form.NFD);
        return result.replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStreamAsString(InputStream stream, String encoding) throws IOException {
        String string;
        BufferedReader in = null;
        try {
            String inputLine;
            in = new BufferedReader(new InputStreamReader(stream, Charset.forName(encoding)));
            StringBuffer sb = new StringBuffer();
            int count = 0;
            while ((inputLine = in.readLine()) != null) {
                if (count > 0) {
                    sb.append(LINE_SEPARATOR);
                }
                sb.append(inputLine);
                ++count;
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            FileUtils.closeQuietly(in);
            throw throwable;
        }
        FileUtils.closeQuietly(in);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readReaderAsString(Reader in, int bufferSize) {
        char[] buffer = new char[bufferSize];
        StringBuilder out = new StringBuilder();
        try {
            int rsz;
            while ((rsz = in.read(buffer, 0, buffer.length)) >= 0) {
                out.append(buffer, 0, rsz);
            }
        }
        catch (Exception e) {
        }
        finally {
            FileUtils.closeQuietly(in);
        }
        return out.toString();
    }

    public static String readFileAsString(File file, String encoding) throws IOException {
        return StringUtils.readStreamAsString(new FileInputStream(file), encoding);
    }

    public static String trim(String string) {
        if (string != null) {
            return string.trim();
        }
        return null;
    }

    public static int getUnicodeCode(String letter) {
        char c = letter.charAt(0);
        return c;
    }

    public static String getCharacterForCode(int unicode) {
        return String.valueOf((char)unicode);
    }

    public static String localeSafeToUppercase(String value) {
        if (value != null) {
            return value.toUpperCase(Locale.ENGLISH);
        }
        return null;
    }

    public static String localeSafeToLowercase(String value) {
        if (value != null) {
            return value.toLowerCase(Locale.ENGLISH);
        }
        return null;
    }

    public static byte[] hexStringToByteArray(String str) {
        char[] hex = str.toCharArray();
        int length = hex.length / 2;
        byte[] raw = new byte[length];
        for (int i = 0; i < length; ++i) {
            int low;
            int high = Character.digit(hex[i * 2], 16);
            int value = high << 4 | (low = Character.digit(hex[i * 2 + 1], 16));
            if (value > 127) {
                value -= 256;
            }
            raw[i] = (byte)value;
        }
        return raw;
    }

    public static String removeNewLineCharacters(String text) {
        return text.replaceAll("[\\r\\n]", "");
    }

    public static String[] splitStringToLines(String content) {
        return content.split("\\r?\\n|\\r");
    }

    public static final String trimWithEllipsis(String text, int maxLength) {
        if (ObjectValidator.isNotEmpty(text)) {
            if (text.length() > maxLength) {
                return text.substring(0, maxLength - 3) + "...";
            }
            return text;
        }
        return text;
    }

    public static String generateRandomToken() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String toString(Object o) {
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    public static String replaceLast(String value, Pattern pattern, String replacement, boolean includeTail) {
        Matcher m = pattern.matcher(value);
        Integer start = 0;
        Integer end = value.length() - 1;
        boolean found = false;
        while (m.find()) {
            start = m.start();
            end = m.end();
            found = true;
        }
        if (found) {
            StringBuffer sb = new StringBuffer();
            sb.append(value.substring(0, start));
            sb.append(replacement);
            if (includeTail) {
                sb.append(value.substring(end));
            }
            return sb.toString();
        }
        return value;
    }
}

