/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.util;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.serviio.library.entities.OnlineRepository;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.util.HttpUtils;
import org.serviio.util.ObjectValidator;

public class ServiioUri {
    public static final String SCHEMA = "serviio";
    private static final Pattern linkPattern = Pattern.compile("serviio://(\\w+):(\\w+)/?\\?(.+)", 2);
    private static final String PARAM_URL = "url";
    private static final String PARAM_THURL = "thUrl";
    private static final String PARAM_NAME = "name";
    private static final String REPO_TYPE_WEB = "web";
    private static final String REPO_TYPE_LIVE = "live";
    private static final String REPO_TYPE_FEED = "feed";
    private static final String FILE_TYPE_IMAGE = "image";
    private static final String FILE_TYPE_AUDIO = "audio";
    private static final String FILE_TYPE_VIDEO = "video";
    private String repositoryUrl;
    private MediaFileType fileType;
    private OnlineRepository.OnlineRepositoryType repoType;
    private String thumbnailUrl;
    private String repositoryName;

    public ServiioUri(MediaFileType fileType, OnlineRepository.OnlineRepositoryType repoType, String repositoryUrl, String thumbnailUrl, String repositoryName) {
        this.fileType = fileType;
        this.repoType = repoType;
        this.repositoryUrl = repositoryUrl;
        this.thumbnailUrl = thumbnailUrl;
        this.repositoryName = repositoryName;
    }

    public static ServiioUri get(String uri) {
        if (ObjectValidator.isNotEmpty(uri)) {
            Matcher m = linkPattern.matcher(uri);
            if (m.find() && m.groupCount() == 3) {
                MediaFileType fileType = ServiioUri.fileType(m.group(1));
                OnlineRepository.OnlineRepositoryType repoType = ServiioUri.repositoryType(m.group(2));
                String query = m.group(3);
                if (ObjectValidator.isEmpty(query)) {
                    throw new IllegalArgumentException("Serviio URI path is missing: " + uri);
                }
                Map<String, String> queryMap = HttpUtils.splitQuery(query);
                if (!queryMap.containsKey(PARAM_URL)) {
                    throw new IllegalArgumentException("Serviio URI is invalid, missing url parameter: " + uri);
                }
                return new ServiioUri(fileType, repoType, queryMap.get(PARAM_URL), queryMap.get(PARAM_THURL), queryMap.get(PARAM_NAME));
            }
            throw new IllegalArgumentException("Serviio URI is invalid: " + uri);
        }
        return null;
    }

    public String toString() {
        return this.toURI();
    }

    public String toURI() {
        StringBuilder builder = new StringBuilder();
        builder.append(SCHEMA).append("://").append(this.fileType(this.fileType)).append(":").append(this.repositoryType(this.repoType));
        builder.append("?").append(PARAM_URL).append("=").append(HttpUtils.urlEncode(this.repositoryUrl));
        if (ObjectValidator.isNotEmpty(this.thumbnailUrl)) {
            builder.append("&").append(PARAM_THURL).append("=").append(HttpUtils.urlEncode(this.thumbnailUrl));
        }
        if (ObjectValidator.isNotEmpty(this.repositoryName)) {
            builder.append("&").append(PARAM_NAME).append("=").append(HttpUtils.urlEncode(this.repositoryName));
        }
        return builder.toString();
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public MediaFileType getFileType() {
        return this.fileType;
    }

    public OnlineRepository.OnlineRepositoryType getRepoType() {
        return this.repoType;
    }

    public String getThumbnailUrl() {
        return this.thumbnailUrl;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    private String fileType(MediaFileType ft) {
        switch (ft) {
            case VIDEO: {
                return FILE_TYPE_VIDEO;
            }
            case AUDIO: {
                return FILE_TYPE_AUDIO;
            }
            case IMAGE: {
                return FILE_TYPE_IMAGE;
            }
        }
        throw new IllegalArgumentException("Unexpected FileType");
    }

    private static MediaFileType fileType(String ft) {
        if (ft.equalsIgnoreCase(FILE_TYPE_VIDEO)) {
            return MediaFileType.VIDEO;
        }
        if (ft.equalsIgnoreCase(FILE_TYPE_AUDIO)) {
            return MediaFileType.AUDIO;
        }
        if (ft.equalsIgnoreCase(FILE_TYPE_IMAGE)) {
            return MediaFileType.IMAGE;
        }
        throw new IllegalArgumentException("Invalid media file type: " + ft);
    }

    private static OnlineRepository.OnlineRepositoryType repositoryType(String rt) {
        if (rt.equalsIgnoreCase(REPO_TYPE_FEED)) {
            return OnlineRepository.OnlineRepositoryType.FEED;
        }
        if (rt.equalsIgnoreCase(REPO_TYPE_LIVE)) {
            return OnlineRepository.OnlineRepositoryType.LIVE_STREAM;
        }
        if (rt.equalsIgnoreCase(REPO_TYPE_WEB)) {
            return OnlineRepository.OnlineRepositoryType.WEB_RESOURCE;
        }
        throw new IllegalArgumentException("Invalid online repository type: " + rt);
    }

    private String repositoryType(OnlineRepository.OnlineRepositoryType rt) {
        switch (rt) {
            case FEED: {
                return REPO_TYPE_FEED;
            }
            case LIVE_STREAM: {
                return REPO_TYPE_LIVE;
            }
            case WEB_RESOURCE: {
                return REPO_TYPE_WEB;
            }
        }
        throw new IllegalArgumentException("Unexpected OnlineRepositoryType");
    }
}

