/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ServiioThreadFactory
implements ThreadFactory {
    private static final String GROUP_NAME = "ServioThreads";
    private static final String THREAD_PREFIX = "ServioThread-";
    private static ServiioThreadFactory instance;
    private ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);

    private ServiioThreadFactory() {
        this.group = new ThreadGroup(GROUP_NAME);
    }

    public static ServiioThreadFactory getInstance() {
        if (instance == null) {
            instance = new ServiioThreadFactory();
        }
        return instance;
    }

    @Override
    public Thread newThread(Runnable r) {
        return this.newThread(r, null, true);
    }

    public Thread newThread(Runnable r, String name, boolean daemon) {
        Thread t = new Thread(this.group, r, THREAD_PREFIX + this.threadNumber.getAndIncrement() + "-" + name);
        t.setDaemon(daemon);
        t.setPriority(5);
        return t;
    }
}

