/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.util;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.restlet.engine.util.Base64;
import org.serviio.util.AES;
import org.serviio.util.StringUtils;

public class SecurityUtils {
    public static String generateMacAsHex(String privateKey, String input, String algorithm) throws Exception {
        return SecurityUtils.byteArrayToHex(SecurityUtils.generateMac(privateKey, input, algorithm));
    }

    public static String generateMacAsBase64(String privateKey, String input, String algorithm) throws Exception {
        return Base64.encode((byte[])SecurityUtils.generateMac(privateKey, input, algorithm), (boolean)false);
    }

    public static byte[] decrypt(String privateKey, String input, String algorithm) throws Exception {
        return SecurityUtils.decryptMethod(privateKey, input, algorithm);
    }

    public static String decryptAsHex(String privateKey, String input, String algorithm) throws Exception {
        return SecurityUtils.byteArrayToHex(SecurityUtils.decryptMethod(privateKey, input, algorithm));
    }

    public static String decryptAES(String key, String iv, String hexText) {
        StringBuffer out = new StringBuffer();
        try {
            byte[] keyBytes = StringUtils.hexStringToByteArray(key);
            byte[] textBytes = StringUtils.hexStringToByteArray(hexText);
            byte[] result = AES.decrypt(textBytes, keyBytes);
            byte[] xorkey = iv.getBytes("ASCII");
            int i = 0;
            while ((double)i < Math.ceil(textBytes.length / 16)) {
                String res = SecurityUtils.xor(xorkey, Arrays.copyOfRange(result, i * 16, i * 16 + 16));
                xorkey = Arrays.copyOfRange(textBytes, i * 16, i * 16 + 16);
                out.append(res);
                ++i;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return out.toString().trim();
    }

    private static byte[] generateMac(String privateKey, String input, String algorithm) throws Exception {
        byte[] keyBytes = privateKey.getBytes();
        SecretKeySpec key = new SecretKeySpec(keyBytes, 0, keyBytes.length, algorithm);
        Mac mac = Mac.getInstance(algorithm);
        mac.init(key);
        return mac.doFinal(input.getBytes());
    }

    private static byte[] decryptMethod(String input, String privateKey, String algorithm) throws Exception {
        byte[] keyBytes = privateKey.getBytes();
        SecretKeySpec key = new SecretKeySpec(keyBytes, algorithm);
        Cipher c = Cipher.getInstance(algorithm);
        c.init(2, key);
        return c.doFinal(input.getBytes());
    }

    private static String xor(byte[] s1, byte[] s2) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s1.length && i < s2.length; ++i) {
            sb.append((char)(s1[i] ^ s2[i]));
        }
        return sb.toString();
    }

    public static String byteArrayToHex(byte[] a) {
        String hexDigitChars = "0123456789abcdef";
        StringBuffer buf = new StringBuffer(a.length * 2);
        for (int cx = 0; cx < a.length; ++cx) {
            int hn = (a[cx] & 0xFF) / 16;
            int ln = a[cx] & 0xF;
            buf.append(hexDigitChars.charAt(hn));
            buf.append(hexDigitChars.charAt(ln));
        }
        return buf.toString();
    }
}

