/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.util;

import java.lang.reflect.Field;
import org.jvnet.winp.WinProcess;
import org.serviio.external.ProcessExecutor;
import org.serviio.external.ProcessExecutorParameter;
import org.serviio.external.ProcessListener;
import org.serviio.util.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessUtils {
    private static final Logger log = LoggerFactory.getLogger(ProcessUtils.class);

    public static void destroy(Process p) {
        if (Platform.isWindows()) {
            WinProcess wp = new WinProcess(p);
            log.debug("Killing the Windows process: " + wp.getPid());
            wp.killRecursively();
        } else {
            ProcessUtils.destroyUnixProcess(p);
        }
    }

    private static Integer getProcessID(Process p) {
        Integer pid = null;
        if (p != null && p.getClass().getName().equals("java.lang.UNIXProcess")) {
            try {
                Field f = p.getClass().getDeclaredField("pid");
                f.setAccessible(true);
                pid = f.getInt(p);
            }
            catch (Throwable e) {
                log.debug("Can't determine the Unix process ID: " + e.getMessage());
            }
        }
        return pid;
    }

    private static void destroyUnixProcess(Process p) {
        if (p != null) {
            Integer pid = ProcessUtils.getProcessID(p);
            if (pid != null) {
                ProcessUtils.kill(p, pid, 9);
            } else {
                p.destroy();
            }
        }
    }

    private static void kill(Process p, Integer pid, int signal) {
        log.debug("Sending kill -" + signal + " to the Unix process: " + pid);
        ProcessExecutor pw = new ProcessExecutor(new ProcessExecutorParameter[]{new ProcessExecutorParameter("kill"), new ProcessExecutorParameter("-" + signal), new ProcessExecutorParameter(pid.toString())});
        pw.addListener(new TaskKillProcessListener(p));
        pw.run();
    }

    private static class TaskKillProcessListener
    extends ProcessListener {
        private Process p;

        public TaskKillProcessListener(Process p) {
            this.p = p;
        }

        @Override
        public void processEnded(boolean success) {
            if (!success) {
                this.p.destroy();
            }
        }

        @Override
        public void outputUpdated(String updatedLine) {
        }

        @Override
        public void releaseResources() {
        }
    }
}

