/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.util;

import java.net.NetworkInterface;
import java.util.Comparator;
import org.serviio.util.StringComparators;
import org.serviio.util.StringUtils;

public class NetworkInterfaceComparator
implements Comparator<NetworkInterface> {
    @Override
    public int compare(NetworkInterface o1, NetworkInterface o2) {
        String name1 = StringUtils.trim(StringUtils.localeSafeToLowercase(o1.getName()));
        String name2 = StringUtils.trim(StringUtils.localeSafeToLowercase(o2.getName()));
        return this.compareByName(name1, name2);
    }

    protected int compareByName(String name1, String name2) {
        if (name1 == null) {
            return -1;
        }
        if (name2 == null) {
            return 1;
        }
        if (name1.startsWith("eth") && name2.startsWith("eth")) {
            return StringComparators.compareNaturalAscii(name1, name2);
        }
        if (name1.startsWith("eth")) {
            return -1;
        }
        if (name2.startsWith("eth")) {
            return 1;
        }
        return StringComparators.compareNaturalAscii(name1, name2);
    }
}

