/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.util;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.serviio.util.CollectionUtils;
import org.serviio.util.NicIP;
import org.serviio.util.ObjectValidator;
import org.serviio.util.ThreadUtils;
import org.serviio.util.Tupple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiCastUtils {
    private static final Logger log = LoggerFactory.getLogger(MultiCastUtils.class);
    public static final boolean tosEnabled = MultiCastUtils.isTOSEnabled();

    public static MulticastSocket startMultiCastSocketForListening(InetSocketAddress group, NetworkInterface networkInterface, int ttl) throws IOException {
        MulticastSocket socket = new MulticastSocket(group.getPort());
        socket.setTimeToLive(ttl);
        socket.setReuseAddress(true);
        socket.joinGroup(group, networkInterface);
        if (tosEnabled) {
            socket.setTrafficClass(4);
        }
        return socket;
    }

    public static MulticastSocket startMultiCastSocketForSending(NetworkInterface networkInterface, InetAddress boundAddress, int ttl) throws IOException {
        MulticastSocket socket = new MulticastSocket();
        socket.setTimeToLive(ttl);
        socket.setInterface(boundAddress);
        if (tosEnabled) {
            socket.setTrafficClass(4);
        }
        try {
            socket.setNetworkInterface(networkInterface);
        }
        catch (SocketException e) {
            // empty catch block
        }
        socket.setReuseAddress(true);
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopMultiCastSocket(MulticastSocket socket, InetSocketAddress group, boolean leaveGroup) {
        if (socket != null) {
            try {
                if (leaveGroup) {
                    socket.leaveGroup(group.getAddress());
                }
            }
            catch (Exception ex) {
                log.debug("Problem leaving multicast group", (Throwable)ex);
            }
            finally {
                if (!socket.isClosed()) {
                    socket.close();
                }
            }
        }
    }

    public static DatagramSocket startUniCastSocket() throws IOException {
        DatagramSocket ssdpUniSock = new DatagramSocket();
        if (tosEnabled) {
            ssdpUniSock.setTrafficClass(4);
        }
        return ssdpUniSock;
    }

    public static void send(String message, DatagramSocket socket, SocketAddress target) throws IOException {
        byte[] pk = message.getBytes();
        socket.send(new DatagramPacket(pk, pk.length, target));
    }

    public static DatagramPacket receive(DatagramSocket socket) throws IOException {
        byte[] buf = new byte[2048];
        DatagramPacket input = new DatagramPacket(buf, buf.length);
        socket.receive(input);
        return input;
    }

    public static String getPacketData(DatagramPacket packet) {
        String received = new String(packet.getData(), packet.getOffset(), packet.getLength());
        return received;
    }

    public static Set<NetworkInterface> findSuitableInterfaces() throws SocketException {
        HashSet<NetworkInterface> ifaceList = new HashSet<NetworkInterface>();
        Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
        while (ifaces.hasMoreElements()) {
            NetworkInterface iface = ifaces.nextElement();
            if (iface.isLoopback() || iface.isVirtual() || iface.isPointToPoint() || !iface.isUp() || !iface.supportsMulticast() || MultiCastUtils.findIPAddresses(iface).size() <= 0) continue;
            ifaceList.add(iface);
        }
        return ifaceList;
    }

    public static Set<NetworkInterface> findAllAvailableInterfaces() throws SocketException {
        HashSet<NetworkInterface> ifaceList = new HashSet<NetworkInterface>();
        Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
        while (ifaces.hasMoreElements()) {
            NetworkInterface iface = ifaces.nextElement();
            if (iface.isLoopback() || iface.isPointToPoint() || !iface.isUp() || !iface.supportsMulticast() || MultiCastUtils.findIPAddresses(iface).size() <= 0) continue;
            ifaceList.add(iface);
        }
        return ifaceList;
    }

    public static List<NicIP> findIPAddresses(NetworkInterface iface) {
        ArrayList<NicIP> ips = new ArrayList<NicIP>();
        int index = 0;
        Enumeration<InetAddress> addresses = iface.getInetAddresses();
        while (addresses.hasMoreElements()) {
            InetAddress address = addresses.nextElement();
            if (!(address instanceof Inet4Address)) continue;
            ips.add(new NicIP(iface, address, index));
            ++index;
        }
        return ips;
    }

    public static NicIP findNicIP(InetAddress ipAddress) throws IOException {
        Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
        while (ifaces.hasMoreElements()) {
            NetworkInterface iface = ifaces.nextElement();
            List<NicIP> ifaceIps = MultiCastUtils.findIPAddresses(iface);
            for (NicIP nicIp : ifaceIps) {
                if (!ipAddress.equals(nicIp.getIp())) continue;
                return nicIp;
            }
        }
        throw new IOException("No network inferface found for IP " + ipAddress.getHostAddress());
    }

    public static Tupple<NicIP, Boolean> findNicIPWithRetry(InetAddress ipAddress) throws IOException {
        int countdown = 10;
        NicIP nicIP = null;
        boolean retried = false;
        do {
            try {
                nicIP = MultiCastUtils.findNicIP(ipAddress);
            }
            catch (IOException e) {
                // empty catch block
            }
            if (nicIP != null || --countdown <= 0) continue;
            retried = true;
            log.warn(String.format("Host IP address %s is not available, will try again %s times", ipAddress.getHostAddress(), countdown));
            ThreadUtils.currentThreadSleep(5000L);
        } while (nicIP == null && countdown > 0);
        if (nicIP == null) {
            throw new IOException("No network inferface found for IP " + ipAddress.getHostAddress());
        }
        return new Tupple<NicIP, Boolean>(nicIP, retried);
    }

    public static String getInterfaceName(NetworkInterface iface) {
        if (iface != null) {
            return String.format("%s (%s)", iface.getName(), iface.getDisplayName());
        }
        return "Unknown";
    }

    public static InetAddress getIPAddressForNICWithIndex(String nicWithIndex) {
        if (ObjectValidator.isEmpty(nicWithIndex)) {
            return null;
        }
        List<String> values = CollectionUtils.csvToList(nicWithIndex, "-", false);
        if (values.size() == 2) {
            String nicName = values.get(0);
            int ipIndex = Integer.valueOf(values.get(1));
            try {
                Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
                while (ifaces.hasMoreElements()) {
                    NetworkInterface iface = ifaces.nextElement();
                    List<NicIP> ifaceIps = MultiCastUtils.findIPAddresses(iface);
                    for (NicIP ifaceIp : ifaceIps) {
                        if (ifaceIp.getNicName() == null || !ifaceIp.getNicName().equals(nicName) || ifaceIp.getIpIndex() != ipIndex) continue;
                        return ifaceIp.getIp();
                    }
                }
            }
            catch (SocketException e) {
                // empty catch block
            }
        }
        log.warn(String.format("Could not find NIC with name '%s'", nicWithIndex));
        return null;
    }

    private static boolean isTOSEnabled() {
        if (ObjectValidator.isEmpty(System.getProperty("serviio.useNetworkTOS"))) {
            return false;
        }
        return Boolean.parseBoolean(System.getProperty("serviio.useNetworkTOS"));
    }
}

