/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.util;

import org.serviio.util.ObjectValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaUtils {
    private static final Logger log = LoggerFactory.getLogger(MediaUtils.class);

    public static Integer convertBitrateFromKbpsToByPS(Integer bitrate) {
        if (bitrate != null && bitrate > 0) {
            return bitrate * 1000 / 8;
        }
        return null;
    }

    public static String getValidFps(String fps) {
        String validFrameRate = fps;
        if (ObjectValidator.isNotEmpty(fps)) {
            try {
                double fr = Double.parseDouble(fps);
                validFrameRate = fr > 23.9 && fr < 23.99 ? "23.976" : (fr > 23.99 && fr < 24.1 ? "24" : (fr >= 24.99 && fr < 25.1 ? "25" : (fr > 29.9 && fr < 29.99 ? "29.97" : (fr >= 29.99 && fr < 30.1 ? "30" : (fr > 49.9 && fr < 50.1 ? "50" : (fr > 59.9 && fr < 59.99 ? "59.94" : (fr >= 59.99 && fr < 60.1 ? "60" : "23.976")))))));
            }
            catch (NumberFormatException nfe) {
                log.debug(String.format("Cannot get valid FPS of video file: %s", fps));
            }
        }
        return validFrameRate;
    }

    public static String formatFpsForFFmpeg(String fps) {
        String normalizedFps = MediaUtils.getValidFps(fps);
        if (normalizedFps.equals("23.976")) {
            return "24000/1001";
        }
        if (normalizedFps.equals("29.97")) {
            return "30000/1001";
        }
        if (normalizedFps.equals("59.94")) {
            return "60000/1001";
        }
        return normalizedFps;
    }
}

