/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class JsonUtils {
    public static Map<String, Object> parseJson(String json) throws JsonSyntaxException {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Object.class, (Object)new NaturalDeserializer());
        Gson gson = gsonBuilder.create();
        return (Map)gson.fromJson(json, Object.class);
    }

    private static class NaturalDeserializer
    implements JsonDeserializer<Object> {
        private NaturalDeserializer() {
        }

        public Object deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            if (json.isJsonNull()) {
                return null;
            }
            if (json.isJsonPrimitive()) {
                return this.handlePrimitive(json.getAsJsonPrimitive());
            }
            if (json.isJsonArray()) {
                return this.handleArray(json.getAsJsonArray(), context);
            }
            return this.handleObject(json.getAsJsonObject(), context);
        }

        private Object handlePrimitive(JsonPrimitive json) {
            if (json.isBoolean()) {
                return json.getAsBoolean();
            }
            if (json.isString()) {
                return json.getAsString();
            }
            BigDecimal bigDec = json.getAsBigDecimal();
            try {
                bigDec.toBigIntegerExact();
                try {
                    return bigDec.intValueExact();
                }
                catch (ArithmeticException e) {
                    return bigDec.longValue();
                }
            }
            catch (ArithmeticException arithmeticException) {
                return bigDec.doubleValue();
            }
        }

        private Object handleArray(JsonArray json, JsonDeserializationContext context) {
            ArrayList<Object> array = new ArrayList<Object>(json.size());
            for (int i = 0; i < json.size(); ++i) {
                array.add(this.deserialize(json.get(i), (Type)((Object)Object.class), context));
            }
            return array;
        }

        private Object handleObject(JsonObject json, JsonDeserializationContext context) {
            HashMap map = new HashMap();
            for (Map.Entry entry : json.entrySet()) {
                map.put(entry.getKey(), this.deserialize((JsonElement)entry.getValue(), (Type)((Object)Object.class), context));
            }
            return map;
        }
    }
}

