/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.util;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import org.serviio.db.DatabaseManager;
import org.serviio.util.ObjectValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcUtils {
    private static final Logger log = LoggerFactory.getLogger(JdbcUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeBatchStatement(String sqlFile) {
        String[] commands;
        Connection con = null;
        Statement s = null;
        for (String command : commands = sqlFile.split(";")) {
            if ((command = command.trim()).equals("")) continue;
            try {
                con = DatabaseManager.getConnection(true);
                s = con.createStatement();
                s.executeUpdate(command);
            }
            catch (SQLException e) {
                try {
                    log.debug("An exception occurend when executing SQL statement", (Throwable)e);
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeStatement(s);
                    DatabaseManager.releaseConnection(con);
                    throw throwable;
                }
                JdbcUtils.closeStatement(s);
                DatabaseManager.releaseConnection(con);
                continue;
            }
            JdbcUtils.closeStatement(s);
            DatabaseManager.releaseConnection(con);
        }
    }

    public static void closeStatement(Statement s) {
        if (s != null) {
            try {
                s.close();
            }
            catch (SQLException e) {
                log.warn(String.format("Cannot close DB Statement", e));
            }
        }
    }

    public static void rollback(Connection con) {
        try {
            con.rollback();
        }
        catch (SQLException e) {
            log.error(String.format("Cannot perform rollback", e));
        }
    }

    public static long retrieveGeneratedID(Statement s) throws SQLException {
        ResultSet rs = s.getGeneratedKeys();
        if (rs.next()) {
            long idColVar = rs.getLong(1);
            return idColVar;
        }
        throw new SQLException("Cannot retrieve generated id from the last Statement");
    }

    public static Integer getIntFromResultSet(ResultSet rs, String columnLabel) throws SQLException {
        String strValue = rs.getString(columnLabel);
        if (ObjectValidator.isNotEmpty(strValue)) {
            return new Integer(strValue);
        }
        return null;
    }

    public static Boolean getBooleanFromResultSet(ResultSet rs, String columnLabel) throws SQLException {
        String strValue = rs.getString(columnLabel);
        if (ObjectValidator.isNotEmpty(strValue)) {
            return strValue.equals("1") ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    public static Long getLongFromResultSet(ResultSet rs, String columnLabel) throws SQLException {
        String strValue = rs.getString(columnLabel);
        if (ObjectValidator.isNotEmpty(strValue)) {
            return new Long(strValue);
        }
        return null;
    }

    public static Float getFloatFromResultSet(ResultSet rs, String columnLabel) throws SQLException {
        String strValue = rs.getString(columnLabel);
        if (ObjectValidator.isNotEmpty(strValue)) {
            return new Float(strValue);
        }
        return null;
    }

    public static URL getURLFromResultSet(ResultSet rs, String columnLabel) throws SQLException, MalformedURLException {
        String strValue = rs.getString(columnLabel);
        if (ObjectValidator.isNotEmpty(strValue)) {
            return new URL(strValue);
        }
        return null;
    }

    public static void setLongValueOnStatement(PreparedStatement ps, int paramNumber, Long value) throws SQLException {
        if (value == null) {
            ps.setNull(paramNumber, -5);
        } else {
            ps.setLong(paramNumber, value);
        }
    }

    public static void setIntValueOnStatement(PreparedStatement ps, int paramNumber, Integer value) throws SQLException {
        if (value == null) {
            ps.setNull(paramNumber, 4);
        } else {
            ps.setInt(paramNumber, value);
        }
    }

    public static void setFloatValueOnStatement(PreparedStatement ps, int paramNumber, Float value) throws SQLException {
        if (value == null) {
            ps.setNull(paramNumber, 7);
        } else {
            ps.setFloat(paramNumber, value.floatValue());
        }
    }

    public static void setStringValueOnStatement(PreparedStatement ps, int paramNumber, String value) throws SQLException {
        if (value == null) {
            ps.setNull(paramNumber, 12);
        } else {
            ps.setString(paramNumber, value);
        }
    }

    public static void setBooleanValueOnStatement(PreparedStatement ps, int paramNumber, Boolean value) throws SQLException {
        if (value == null) {
            ps.setNull(paramNumber, 16);
        } else {
            ps.setBoolean(paramNumber, value);
        }
    }

    public static void setURLValueOnStatement(PreparedStatement ps, int paramNumber, URL value) throws SQLException {
        if (value == null) {
            JdbcUtils.setStringValueOnStatement(ps, paramNumber, null);
        } else {
            JdbcUtils.setStringValueOnStatement(ps, paramNumber, value.toString());
        }
    }

    public static void setTimestampValueOnStatement(PreparedStatement ps, int paramNumber, Date value) throws SQLException {
        if (value == null) {
            ps.setNull(paramNumber, 93);
        } else {
            try {
                ps.setTimestamp(paramNumber, new Timestamp(value.getTime()));
            }
            catch (SQLDataException e) {
                log.warn(String.format("Incorrect date: %s, using current date instead", value.toString()), (Throwable)e);
                ps.setTimestamp(paramNumber, new Timestamp(System.currentTimeMillis()));
            }
        }
    }

    public static byte[] convertBlob(Blob blob) {
        if (blob == null) {
            return null;
        }
        try {
            InputStream in = blob.getBinaryStream();
            int len = (int)blob.length();
            long pos = 1L;
            byte[] bytes = blob.getBytes(pos, len);
            in.close();
            return bytes;
        }
        catch (Exception e) {
            log.error("Cannot retrieve BLOB from database: " + e.getMessage());
            return null;
        }
    }

    public static String createInClause(int numberOfParameters) {
        StringBuilder inClause = new StringBuilder();
        boolean firstValue = true;
        for (int i = 0; i < numberOfParameters; ++i) {
            if (firstValue) {
                firstValue = false;
            } else {
                inClause.append(',');
            }
            inClause.append('?');
        }
        return inClause.toString();
    }

    public static String trimToMaxLength(String text, int maxLength) {
        if (ObjectValidator.isNotEmpty(text) && text.length() > maxLength) {
            return text.substring(0, maxLength);
        }
        return text;
    }
}

