/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.util;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.serviio.library.local.metadata.ImageDescriptor;
import org.serviio.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageUtils {
    private static final Logger log = LoggerFactory.getLogger(ImageUtils.class);

    public static ImageDescriptor resizeImageAsJPG(byte[] pImageData, int pMaxWidth, int pMaxHeight) {
        ByteArrayOutputStream encoderOutputStream;
        BufferedImage bufferedResizedImage;
        BufferedImage img;
        ByteArrayInputStream in;
        block6: {
            log.debug(String.format("Starting image resize, size = %s bytes", pImageData.length));
            in = new ByteArrayInputStream(pImageData);
            img = null;
            bufferedResizedImage = null;
            encoderOutputStream = null;
            img = ImageIO.read(in);
            Dimension newImageDimension = ImageUtils.getResizedDimensions(img.getWidth(), img.getHeight(), pMaxWidth, pMaxHeight);
            int width = (int)newImageDimension.getWidth();
            int height = (int)newImageDimension.getHeight();
            bufferedResizedImage = new BufferedImage(width, height, 1);
            Graphics2D g2d = bufferedResizedImage.createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2d.drawImage(img, 0, 0, width, height, null);
            g2d.dispose();
            encoderOutputStream = new ByteArrayOutputStream();
            boolean result = ImageIO.write((RenderedImage)bufferedResizedImage, "jpg", encoderOutputStream);
            if (!result) break block6;
            byte[] resizedImageByteArray = encoderOutputStream.toByteArray();
            ImageDescriptor container = new ImageDescriptor(width, height, resizedImageByteArray);
            log.debug(String.format("Returning resized image, size = %s bytes", resizedImageByteArray.length));
            ImageDescriptor imageDescriptor = container;
            FileUtils.closeQuietly(in);
            FileUtils.closeQuietly(encoderOutputStream);
            ImageUtils.flushBufferedImage(img);
            ImageUtils.flushBufferedImage(bufferedResizedImage);
            img = null;
            bufferedResizedImage = null;
            encoderOutputStream = null;
            return imageDescriptor;
        }
        try {
            try {
                throw new RuntimeException("Error writing JPEG image");
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(String.format("Error reading image for resizing. Message: %s", e.getMessage()));
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Error reading image for resizing. Message: %s", e.getMessage()));
            }
        }
        catch (Throwable throwable) {
            FileUtils.closeQuietly(in);
            FileUtils.closeQuietly(encoderOutputStream);
            ImageUtils.flushBufferedImage(img);
            ImageUtils.flushBufferedImage(bufferedResizedImage);
            img = null;
            bufferedResizedImage = null;
            encoderOutputStream = null;
            throw throwable;
        }
    }

    public static ImageDescriptor resizeImageAsJPG(File imageFile, int pMaxWidth, int pMaxHeight) {
        byte[] imageBytes = null;
        try {
            imageBytes = FileUtils.readFileBytes(imageFile);
            ImageDescriptor imageDescriptor = ImageUtils.resizeImageAsJPG(imageBytes, pMaxWidth, pMaxHeight);
            return imageDescriptor;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            imageBytes = null;
        }
    }

    public static ImageDescriptor loadImage(File imageFile) {
        byte[] imageBytes = null;
        try {
            imageBytes = FileUtils.readFileBytes(imageFile);
            ImageDescriptor imageDescriptor = new ImageDescriptor(imageBytes);
            return imageDescriptor;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            imageBytes = null;
        }
    }

    public static Dimension getResizedDimensions(int currentWidth, int currentHeight, int maxWidth, int maxHeight) {
        if (currentWidth <= maxWidth && currentHeight <= maxHeight) {
            return new Dimension(currentWidth, currentHeight);
        }
        int newWidth = 0;
        int newHeight = 0;
        double ratioWidth = (double)maxWidth / (double)currentWidth;
        double ratioHeight = (double)maxHeight / (double)currentHeight;
        if (ratioWidth < ratioHeight) {
            newHeight = (int)((double)currentHeight * ratioWidth);
            newWidth = maxWidth;
        } else {
            newWidth = (int)((double)currentWidth * ratioHeight);
            newHeight = maxHeight;
        }
        return new Dimension(newWidth == 0 ? 1 : newWidth, newHeight == 0 ? 1 : newHeight);
    }

    public static ImageDescriptor rotateImage(byte[] pImageData, int degrees) {
        ByteArrayOutputStream encoderOutputStream;
        BufferedImage rotatedImage;
        BufferedImage img;
        ByteArrayInputStream in;
        block6: {
            log.debug("Starting image rotate");
            in = new ByteArrayInputStream(pImageData);
            img = null;
            rotatedImage = null;
            encoderOutputStream = null;
            img = ImageIO.read(in);
            int rotatedWidth = degrees == 90 || degrees == 270 ? img.getHeight() : img.getWidth();
            int rotatedHeight = degrees == 90 || degrees == 270 ? img.getWidth() : img.getHeight();
            rotatedImage = new BufferedImage(img.getHeight(), img.getWidth(), img.getType());
            Graphics2D g2d = rotatedImage.createGraphics();
            double x = (double)(img.getHeight() - img.getWidth()) / 2.0;
            double y = (double)(img.getWidth() - img.getHeight()) / 2.0;
            AffineTransform at = AffineTransform.getTranslateInstance(x, y);
            at.rotate(Math.toRadians(degrees), (double)img.getWidth() / 2.0, (double)img.getHeight() / 2.0);
            g2d.drawRenderedImage(img, at);
            g2d.dispose();
            encoderOutputStream = new ByteArrayOutputStream();
            boolean result = ImageIO.write((RenderedImage)rotatedImage, "jpg", encoderOutputStream);
            if (!result) break block6;
            byte[] rotatedImageByteArray = encoderOutputStream.toByteArray();
            ImageDescriptor container = new ImageDescriptor(rotatedWidth, rotatedHeight, rotatedImageByteArray);
            log.debug(String.format("Returning rotated image, size = %s bytes", rotatedImageByteArray.length));
            ImageDescriptor imageDescriptor = container;
            FileUtils.closeQuietly(in);
            FileUtils.closeQuietly(encoderOutputStream);
            ImageUtils.flushBufferedImage(img);
            ImageUtils.flushBufferedImage(rotatedImage);
            img = null;
            rotatedImage = null;
            return imageDescriptor;
        }
        try {
            try {
                throw new RuntimeException("Error writing JPEG image");
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(String.format("Error rotating image. Message: %s", e.getMessage()));
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Error reading image for rotating. Message: %s", e.getMessage()));
            }
        }
        catch (Throwable throwable) {
            FileUtils.closeQuietly(in);
            FileUtils.closeQuietly(encoderOutputStream);
            ImageUtils.flushBufferedImage(img);
            ImageUtils.flushBufferedImage(rotatedImage);
            img = null;
            rotatedImage = null;
            throw throwable;
        }
    }

    private static void flushBufferedImage(BufferedImage img) {
        if (img != null) {
            img.flush();
        }
    }
}

