/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.util;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import org.serviio.util.ObjectValidator;

public class IcyInputStream
extends FilterInputStream {
    private int metaInt = 0;
    private int bytesRead = 0;
    private URLConnection connection;
    private String contentType;

    public static IcyInputStream create(String url) throws IOException {
        URLConnection connection = new URL(url).openConnection();
        IcyInputStream icyInputStream = new IcyInputStream(new BufferedInputStream(IcyInputStream.openConnection(url)));
        icyInputStream.setConnection(connection);
        icyInputStream.init();
        return icyInputStream;
    }

    private static InputStream openConnection(String urlString) throws IOException {
        URL url = new URL(urlString);
        int port = url.getPort() == -1 ? 80 : url.getPort();
        String path = ObjectValidator.isEmpty(url.getPath()) ? "/" : url.getPath();
        Socket socket = new Socket(url.getHost(), port);
        OutputStream os = socket.getOutputStream();
        String userAgent = "Windows-Media-Player/12.0.7601.17514";
        String req = String.format("GET %s HTTP/1.0\r\nuser-agent: %s\r\nConnection: keep-alive\r\n\r\n", path, userAgent);
        os.write(req.getBytes());
        return socket.getInputStream();
    }

    private IcyInputStream(InputStream in) {
        super(in);
    }

    private void setConnection(URLConnection connection) {
        this.connection = connection;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String readLine() throws IOException {
        int ch = this.read();
        StringBuilder sb = new StringBuilder();
        while (ch != 10 && ch != 13 && ch >= 0) {
            sb.append((char)ch);
            ch = this.read();
        }
        if (ch == 10 || ch == 13) {
            this.read();
        }
        return sb.toString();
    }

    private void init() throws IOException {
        this.contentType = this.connection.getContentType();
        String metaIntString = "0";
        if (this.contentType.equals("unknown/unknown")) {
            String s = this.readLine();
            if (!s.equals("ICY 200 OK")) {
                throw new IOException("SHOUTCast invalid response: " + s);
            }
            while (!(s = this.readLine()).isEmpty()) {
            }
        } else {
            metaIntString = this.connection.getHeaderField("icy-metaint");
        }
        try {
            this.metaInt = Integer.parseInt(metaIntString.trim());
        }
        catch (NumberFormatException e) {
            this.metaInt = 0;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read;
        if (this.metaInt > 0) {
            int bytesToMeta = this.metaInt - this.bytesRead;
            if (bytesToMeta == 0) {
                this.readMeta();
            } else if (bytesToMeta > 0 && bytesToMeta < len) {
                len = bytesToMeta;
            }
        }
        this.bytesRead = read = super.read(b, off, len);
        return read;
    }

    private void readMeta() throws IOException {
        byte[] meta;
        int i;
        int size = this.read() * 16;
        if (size > 1 && (i = super.read(meta = new byte[size], 0, size)) != size) {
            throw new RuntimeException("WTF");
        }
        this.bytesRead = 0;
    }
}

