/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.util;

import java.net.UnknownHostException;

public class IPMask {
    private String i4addr;
    private byte maskCtr;
    private int addrInt;
    private int maskInt;

    private IPMask(String i4addr, byte mask) {
        this.i4addr = i4addr;
        this.maskCtr = mask;
        this.addrInt = IPMask.addrToInt(i4addr);
        this.maskInt = ~((1 << 32 - this.maskCtr) - 1);
    }

    public static IPMask getIPMask(String addrSlashMask) throws UnknownHostException {
        byte maskCtr;
        String addr;
        int pos = addrSlashMask.indexOf(47);
        if (pos == -1) {
            addr = addrSlashMask;
            maskCtr = 32;
        } else {
            addr = addrSlashMask.substring(0, pos);
            maskCtr = Byte.parseByte(addrSlashMask.substring(pos + 1));
        }
        return new IPMask(addr, maskCtr);
    }

    public boolean matches(byte[] testAddr) {
        int testAddrInt = IPMask.addrToInt(testAddr);
        return (this.addrInt & this.maskInt) == (testAddrInt & this.maskInt);
    }

    public boolean matches(String addr) {
        return this.matches(IPMask.textToNumericFormatV4(addr));
    }

    private static int addrToInt(String i4addr) {
        byte[] ba = IPMask.textToNumericFormatV4(i4addr);
        return IPMask.addrToInt(ba);
    }

    private static int addrToInt(byte[] ba) {
        return ba[0] << 24 | (ba[1] & 0xFF) << 16 | (ba[2] & 0xFF) << 8 | ba[3] & 0xFF;
    }

    public String toString() {
        return "IPMask(" + this.i4addr + "/" + this.maskCtr + ")";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IPMask that = (IPMask)obj;
        return this.addrInt == that.addrInt && this.maskInt == that.maskInt;
    }

    public int hashCode() {
        return this.maskInt + this.addrInt;
    }

    public static byte[] textToNumericFormatV4(String src) {
        if (src.length() == 0) {
            return null;
        }
        byte[] res = new byte[4];
        String[] s = src.trim().split("\\.", -1);
        try {
            switch (s.length) {
                case 1: {
                    long val = Long.parseLong(s[0]);
                    if (val < 0L || val > 0xFFFFFFFFL) {
                        return null;
                    }
                    res[0] = (byte)(val >> 24 & 0xFFL);
                    res[1] = (byte)((val & 0xFFFFFFL) >> 16 & 0xFFL);
                    res[2] = (byte)((val & 0xFFFFL) >> 8 & 0xFFL);
                    res[3] = (byte)(val & 0xFFL);
                    break;
                }
                case 2: {
                    long val = Integer.parseInt(s[0]);
                    if (val < 0L || val > 255L) {
                        return null;
                    }
                    res[0] = (byte)(val & 0xFFL);
                    val = Integer.parseInt(s[1]);
                    if (val < 0L || val > 0xFFFFFFL) {
                        return null;
                    }
                    res[1] = (byte)(val >> 16 & 0xFFL);
                    res[2] = (byte)((val & 0xFFFFL) >> 8 & 0xFFL);
                    res[3] = (byte)(val & 0xFFL);
                    break;
                }
                case 3: {
                    long val;
                    for (int i = 0; i < 2; ++i) {
                        val = Integer.parseInt(s[i]);
                        if (val < 0L || val > 255L) {
                            return null;
                        }
                        res[i] = (byte)(val & 0xFFL);
                    }
                    val = Integer.parseInt(s[2]);
                    if (val < 0L || val > 65535L) {
                        return null;
                    }
                    res[2] = (byte)(val >> 8 & 0xFFL);
                    res[3] = (byte)(val & 0xFFL);
                    break;
                }
                case 4: {
                    for (int i = 0; i < 4; ++i) {
                        long val = Integer.parseInt(s[i]);
                        if (val < 0L || val > 255L) {
                            return null;
                        }
                        res[i] = (byte)(val & 0xFFL);
                    }
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return res;
    }
}

