/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.serviio.util.CollectionUtils;
import org.serviio.util.ObjectValidator;
import org.serviio.util.StringUtils;

public class HttpUtils {
    private static final Pattern maxAgePattern = Pattern.compile("([\\d]+)");
    private static final Pattern uriPattern = Pattern.compile("^.+?://.+");
    private static final Pattern urlPattern = Pattern.compile("(.*)://(\\S+):(\\S+)@(.*)?");

    public static boolean isHttpUrl(String url) {
        String lowercaseUrl = StringUtils.localeSafeToLowercase(url);
        return url != null && lowercaseUrl.startsWith("http://") || lowercaseUrl.startsWith("https://");
    }

    public static boolean isUri(String uri) {
        return uriPattern.matcher(uri).matches();
    }

    public static int getMaxAgeFromHeader(Header header) {
        Matcher m;
        String headerValue;
        if (header != null && (headerValue = header.getValue()).startsWith("max-age") && (m = maxAgePattern.matcher(headerValue)).find()) {
            return Integer.valueOf(m.group(1));
        }
        return 0;
    }

    public static String requestToString(HttpRequest request) {
        StringBuffer sb = new StringBuffer();
        sb.append(request.getRequestLine().toString());
        sb.append(", headers = ");
        sb.append(HttpUtils.headersToString(request.getAllHeaders()));
        sb.append("]");
        return sb.toString();
    }

    public static String headersToString(Header[] headers) {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        ArrayList<String> headersList = new ArrayList<String>();
        for (Header header : headers) {
            headersList.add(header.getName() + ": " + header.getValue());
        }
        sb.append(CollectionUtils.listToCSV(headersList, ",", false));
        sb.append("]");
        return sb.toString();
    }

    public static String headersToString(Map<String, String> headers) {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        ArrayList<String> headersList = new ArrayList<String>();
        for (Map.Entry<String, String> header : headers.entrySet()) {
            headersList.add(header.getKey() + ": " + header.getValue());
        }
        sb.append(CollectionUtils.listToCSV(headersList, ",", false));
        sb.append("]");
        return sb.toString();
    }

    public static String responseToString(HttpResponse response) {
        StringBuffer sb = new StringBuffer();
        sb.append(response.getStatusLine().toString());
        sb.append(", headers = [");
        sb.append(HttpUtils.headersToString(response.getAllHeaders()));
        sb.append("]");
        return sb.toString();
    }

    public static String urlDecode(String value) {
        if (value != null) {
            try {
                return URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static String urlEncode(String value) {
        if (value != null) {
            try {
                return URLEncoder.encode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static String[] getCredentialsFormUrl(String url) {
        Matcher m = urlPattern.matcher(url);
        if (!m.matches()) {
            return null;
        }
        String user = HttpUtils.urlDecode(m.group(2));
        String password = HttpUtils.urlDecode(m.group(3));
        return new String[]{user, password};
    }

    public static URLConnection getUrlConnection(URL url) throws IOException {
        String[] credentials = HttpUtils.getCredentialsFormUrl(url.toExternalForm());
        if (credentials == null) {
            return url.openConnection();
        }
        URL urlWithoutCredentials = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile());
        HttpURLConnection uc = (HttpURLConnection)urlWithoutCredentials.openConnection();
        String authorizationString = "Basic " + HttpUtils.buildBasicAuthentication(credentials);
        uc.setRequestProperty("Authorization", authorizationString);
        return uc;
    }

    protected static String buildBasicAuthentication(String[] credentials) {
        String val = new StringBuffer(credentials[0]).append(":").append(credentials[1]).toString();
        return DatatypeConverter.printBase64Binary((byte[])val.getBytes());
    }

    public static String getHostName(String url) throws URISyntaxException {
        if (ObjectValidator.isEmpty(url)) {
            return null;
        }
        URI uri = null;
        uri = !HttpUtils.isUri(url) ? new URI("http://" + url) : new URI(url);
        return uri.getHost();
    }

    public static Map<String, String> splitQuery(String query) {
        String[] pairs;
        LinkedHashMap<String, String> query_pairs = new LinkedHashMap<String, String>();
        for (String pair : pairs = query.split("&")) {
            int idx = pair.indexOf("=");
            query_pairs.put(HttpUtils.urlDecode(pair.substring(0, idx)), HttpUtils.urlDecode(pair.substring(idx + 1)));
        }
        return query_pairs;
    }
}

