/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.util;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.serviio.util.HttpUtils;
import org.serviio.util.IcyInputStream;
import org.serviio.util.ObjectValidator;
import org.serviio.util.StringUtils;
import org.serviio.util.ZipUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient {
    private static final Logger log = LoggerFactory.getLogger(HttpClient.class);
    private static final int CONNECT_TIMEOUT = 20000;
    private static final int READ_TIMEOUT = 30000;
    private static final String DEFAULT_USER_AGENT = "Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/32.0.1667.0 Safari/537.36";

    public static String retrieveTextFileFromURL(String url, String encoding) throws FileNotFoundException, IOException {
        return StringUtils.readStreamAsString(HttpClient.getStreamFromURL(url), encoding);
    }

    public static String retrieveGZippedTextFileFromURL(String url, String encoding) throws FileNotFoundException, IOException {
        return StringUtils.readStreamAsString(ZipUtils.unGzipSingleFile(HttpClient.getStreamFromURL(url)), encoding);
    }

    public static byte[] retrieveBinaryFileFromURL(String url, String userAgent) throws FileNotFoundException, IOException {
        URLConnection connection = HttpClient.prepareConnection(url, userAgent);
        InputStream in = HttpClient.retrieveStreamFromConnection(connection, userAgent, true);
        return HttpClient.readBytesFromStream(in);
    }

    public static byte[] retrieveBinaryFileFromURL(String url) throws FileNotFoundException, IOException {
        return HttpClient.retrieveBinaryFileFromURL(url, null);
    }

    public static InputStream getStreamFromURL(String url) throws IOException {
        URLConnection connection = HttpClient.prepareConnection(url, null);
        return HttpClient.retrieveStreamFromConnection(connection, null, false);
    }

    public static InputStream retrieveBinaryStreamFromURL(String url) throws FileNotFoundException, IOException {
        URLConnection connection = HttpClient.prepareConnection(url, null);
        return HttpClient.retrieveStreamFromConnection(connection, null, true);
    }

    public static InputStream getShoutCastStream(String urlString) throws IOException {
        return IcyInputStream.create(urlString);
    }

    public static Integer getContentSize(URL contentURL) {
        try {
            URLConnection connection = contentURL.openConnection();
            int contentLength = connection.getContentLength();
            return contentLength;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static byte[] readBytesFromStream(InputStream is) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[2048];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    private static URLConnection prepareConnection(String url, String userAgent) throws IOException {
        URL fileURL = new URL(url);
        URLConnection connection = HttpUtils.getUrlConnection(fileURL);
        connection.setConnectTimeout(20000);
        connection.setReadTimeout(30000);
        if (ObjectValidator.isNotEmpty(userAgent)) {
            connection.setRequestProperty("User-Agent", userAgent);
        } else {
            connection.setRequestProperty("User-Agent", DEFAULT_USER_AGENT);
        }
        return connection;
    }

    private static InputStream retrieveStreamFromConnection(URLConnection conn, String userAgent, boolean binary) throws IOException {
        if (conn instanceof HttpURLConnection) {
            boolean redirect;
            int status = ((HttpURLConnection)conn).getResponseCode();
            boolean bl = redirect = status == 302 || status == 301 || status == 303;
            if (redirect) {
                String newUrl = conn.getHeaderField("Location");
                log.debug("Redirect detected, opening target URL: " + newUrl);
                return HttpClient.retrieveStreamFromConnection(HttpClient.prepareConnection(newUrl, userAgent), userAgent, binary);
            }
            return binary ? conn.getInputStream() : (InputStream)conn.getContent();
        }
        return binary ? conn.getInputStream() : (InputStream)conn.getContent();
    }
}

