/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.util;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.io.FilenameUtils;
import org.serviio.util.Platform;
import org.serviio.util.StringUtils;

public class FileUtils {
    public static boolean fileExists(String filePath) {
        File f = new File(filePath);
        return f.exists();
    }

    public static String getProperFilePath(File file) {
        return file.getAbsolutePath();
    }

    public static Date getLastModifiedDate(File file) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(file.lastModified());
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static String getFileExtension(File file) {
        return FileUtils.getFileExtension(file.getName());
    }

    public static String getFileExtension(String fileName) {
        int dotPos = fileName.lastIndexOf(".");
        return fileName.substring(dotPos + 1);
    }

    public static String getFileExtension(URL url) {
        int dotPos;
        if (url != null && (dotPos = url.getPath().lastIndexOf(".")) > -1) {
            return url.getPath().substring(dotPos + 1);
        }
        return null;
    }

    public static String getFileNameWithoutExtension(File file) {
        int dotPos = file.getName().lastIndexOf(".");
        if (dotPos > -1) {
            return file.getName().substring(0, dotPos);
        }
        return file.getName();
    }

    public static String[] splitFilePathToDriveAndRest(String filePath) {
        String drive = filePath.substring(0, filePath.indexOf(58) + 1);
        String path = filePath.substring(drive.length());
        return new String[]{drive, path};
    }

    public static byte[] readFileBytes(File f) throws IOException {
        FileInputStream is = new FileInputStream(f);
        long length = f.length();
        if (length > Integer.MAX_VALUE) {
            ((InputStream)is).close();
            throw new IOException(String.format("File %s is too long", f.getAbsolutePath()));
        }
        return FileUtils.readFileBytes(is, 0, (int)length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileBytes(InputStream is, int maxLength) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int l;
            byte[] buffer = new byte[2048];
            for (int numRead = 0; (l = is.read(buffer)) != -1 && numRead < maxLength; numRead += l) {
                out.write(buffer, 0, l);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            is.close();
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileBytes(InputStream is, int skip, int length) throws IOException {
        try {
            byte[] bytes = new byte[length];
            int numRead = 0;
            for (int offset = skip; offset < bytes.length && (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileBytes(InputStream is) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int l;
            byte[] buffer = new byte[2048];
            while ((l = is.read(buffer)) != -1) {
                out.write(buffer, 0, l);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            is.close();
            out.close();
        }
    }

    public static File getRelativeDirectory(File rootDir, String filePath) {
        String parentDir = rootDir.getPath();
        File file = new File(filePath);
        String fileDir = file.getParent();
        if (Platform.isWindows() && parentDir.equalsIgnoreCase(fileDir) || !Platform.isWindows() && parentDir.equals(fileDir)) {
            return null;
        }
        if (Platform.isWindows() && StringUtils.localeSafeToLowercase(fileDir).indexOf(StringUtils.localeSafeToLowercase(parentDir)) == 0 || !Platform.isWindows() && fileDir.indexOf(parentDir) == 0) {
            String relativeDir = "";
            relativeDir = parentDir.endsWith(File.separator) ? fileDir.substring(parentDir.length()) : fileDir.substring(parentDir.length() + 1);
            return new File(relativeDir);
        }
        throw new RuntimeException(String.format("The provided file path %s doesn't belong to root %s", filePath, rootDir));
    }

    public static void closeQuietly(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(Reader is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static InputStream getStreamFromClasspath(String filePath, Class<?> clazz) throws FileNotFoundException {
        InputStream is = clazz.getResourceAsStream(filePath);
        if (is == null) {
            throw new FileNotFoundException(String.format("File %s doesn't exist on the classpath", filePath));
        }
        return is;
    }

    public static String getFilePathOfClasspathResource(String filePath, Class<?> clazz) {
        try {
            return FileUtils.getProperFilePath(new File(clazz.getResource(filePath).toURI()));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isPathAbsoulute(String filePath) {
        return FilenameUtils.getPrefixLength((String)filePath) > 0;
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream, long limit) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[2048];
        long bytesCopied = 0L;
        while (bytesCopied < limit && (bytesRead = inputStream.read(buffer)) > 0) {
            if (limit - bytesCopied >= (long)bytesRead) {
                outputStream.write(buffer, 0, bytesRead);
                bytesCopied += (long)bytesRead;
                continue;
            }
            int subArrayLength = (int)(limit - bytesCopied);
            outputStream.write(Arrays.copyOfRange(buffer, 0, subArrayLength), 0, subArrayLength);
            bytesCopied += (long)subArrayLength;
        }
        outputStream.flush();
        inputStream.close();
    }

    public static void deleteDirOnExit(File dir) {
        dir.deleteOnExit();
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    FileUtils.deleteDirOnExit(f);
                    continue;
                }
                f.deleteOnExit();
            }
        }
    }

    public static boolean deleteFileOrFolder(File file) {
        return org.apache.commons.io.FileUtils.deleteQuietly((File)file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File targetFile, String text, String encoding) throws IOException {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile), encoding));
            bw.write(text);
            bw.flush();
        }
        finally {
            if (bw != null) {
                bw.close();
            }
        }
    }
}

