/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.serviio.db.entities.PersistedEntity;
import org.serviio.util.ObjectValidator;

public class CollectionUtils {
    public static List<String> csvToList(String value, String separator, boolean trim) {
        if (ObjectValidator.isEmpty(value)) {
            return Collections.emptyList();
        }
        List<String> split = Arrays.asList(value.split(separator));
        if (trim) {
            ArrayList<String> trimmed = new ArrayList<String>(split.size());
            for (String item : split) {
                trimmed.add(item.trim());
            }
            return trimmed;
        }
        return split;
    }

    public static boolean haveSameElements(Collection<String> c1, Collection<String> c2) {
        if (c1.size() != c2.size()) {
            return false;
        }
        return c1.containsAll(c2);
    }

    public static int findIndexOf(List<String> col, String item, boolean caseSensitive) {
        if (caseSensitive) {
            return col.indexOf(item);
        }
        for (int i = 0; i < col.size(); ++i) {
            if (!col.get(i).equalsIgnoreCase(item)) continue;
            return i;
        }
        return -1;
    }

    public static <T> String arrayToCSV(T[] array, String separator) {
        StringBuffer sb = new StringBuffer();
        if (array != null && array.length > 0) {
            for (int i = 0; i < array.length - 1; ++i) {
                sb.append(array[i].toString()).append(separator);
            }
            sb.append(array[array.length - 1]);
        }
        return sb.toString();
    }

    public static String listToCSV(Collection<?> list, String separator, boolean trim) {
        StringBuffer sb = new StringBuffer();
        if (list != null && list.size() > 0) {
            Iterator<?> i = list.iterator();
            while (i.hasNext()) {
                String value = i.next().toString();
                sb.append(trim ? value.trim() : value);
                if (!i.hasNext()) continue;
                sb.append(separator);
            }
        }
        return sb.toString();
    }

    public static String mapToCSV(Map<?, ?> map, String separator, boolean trim) {
        StringBuffer sb = new StringBuffer();
        if (map != null && map.size() > 0) {
            boolean first = true;
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                if (!first) {
                    sb.append(separator);
                }
                sb.append((Object)(trim ? entry.getKey().toString().trim() : entry.getKey()));
                sb.append("=");
                sb.append((Object)(trim ? entry.getValue().toString().trim() : entry.getValue()));
                first = false;
            }
        }
        return sb.toString();
    }

    public static Map<String, String> CSVToMap(String value, String separator) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (ObjectValidator.isNotEmpty(value)) {
            String[] entries;
            for (String entry : entries = value.split(separator)) {
                String[] values = entry.split("=");
                result.put(values[0], values[1]);
            }
        }
        return result;
    }

    public static Object getFirstItem(Collection<?> collection) {
        if (collection != null && !collection.isEmpty()) {
            return collection.iterator().next();
        }
        return null;
    }

    public static <T> T[] setToArray(Set<T> set, Class<T> elementClass) {
        if (set != null) {
            Object[] array = (Object[])Array.newInstance(elementClass, set.size());
            ArrayList<Object> list = new ArrayList<Object>(set);
            return list.toArray(array);
        }
        return null;
    }

    public static <T> Set<T> arrayToSet(T[] array) {
        if (array != null) {
            HashSet<T> set = new HashSet<T>(array.length);
            for (T element : array) {
                set.add(element);
            }
            return set;
        }
        return null;
    }

    public static <T> void addUniqueElementToArray(T[] array, T element, Class<T> elementClass) {
        Set<T> set = CollectionUtils.arrayToSet(array);
        set.add(element);
        array = CollectionUtils.setToArray(set, elementClass);
    }

    public static <T> void removeElementFromArray(T[] array, T element, Class<T> elementClass) {
        Set<T> set = CollectionUtils.arrayToSet(array);
        set.remove(element);
        array = CollectionUtils.setToArray(set, elementClass);
    }

    public static int[] enumSetToOrdinalArray(Set<?> enums) {
        int[] result = new int[enums.size()];
        int i = 0;
        for (Object element : enums) {
            result[i++] = ((Enum)element).ordinal();
        }
        return result;
    }

    public static int[] addUniqueIntToArray(int[] array, int element) {
        if (array != null) {
            HashSet<Integer> set = new HashSet<Integer>(array.length);
            for (int item : array) {
                set.add(item);
            }
            set.add(element);
            int[] newArray = new int[set.size()];
            int i = 0;
            Iterator i$ = set.iterator();
            while (i$.hasNext()) {
                int item;
                item = (Integer)i$.next();
                newArray[i++] = item;
            }
            return newArray;
        }
        return null;
    }

    public static int[] removeIntFromArray(int[] array, int element) {
        if (array != null) {
            HashSet<Integer> set = new HashSet<Integer>(array.length);
            for (int item : array) {
                set.add(item);
            }
            set.remove(element);
            int[] newArray = new int[set.size()];
            int i = 0;
            Iterator i$ = set.iterator();
            while (i$.hasNext()) {
                int item;
                item = (Integer)i$.next();
                newArray[i++] = item;
            }
            return newArray;
        }
        return null;
    }

    public static boolean arrayContainsInt(int[] array, int element) {
        for (int item : array) {
            if (item != element) continue;
            return true;
        }
        return false;
    }

    public static <T> List<T> getSubList(List<T> list, int startIndex, int count) {
        if (startIndex >= list.size()) {
            return Collections.emptyList();
        }
        int endIndex = startIndex + count;
        if (endIndex > list.size()) {
            endIndex = list.size();
        }
        return list.subList(startIndex, endIndex);
    }

    public static <K, V> Map<K, V> getSubMap(Map<K, V> map, int startIndex, int count) {
        int endIndex = startIndex + count;
        if (endIndex > map.size()) {
            endIndex = map.size();
        }
        LinkedHashMap<K, V> result = new LinkedHashMap<K, V>();
        int i = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (i < startIndex || i >= endIndex) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static List<Long> extractEntityIDs(List<? extends PersistedEntity> entities) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (PersistedEntity persistedEntity : entities) {
            ids.add(persistedEntity.getId());
        }
        return ids;
    }

    public static void removeNulls(Collection<?> col) {
        col.remove(null);
    }

    public static <T> T[] concatenateArrays(T[] A, T[] B) {
        int aLen = A.length;
        int bLen = B.length;
        Object[] C = (Object[])Array.newInstance(A.getClass().getComponentType(), aLen + bLen);
        System.arraycopy(A, 0, C, 0, aLen);
        System.arraycopy(B, 0, C, aLen, bLen);
        return C;
    }
}

