/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.webserver;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.UUID;
import org.apache.http.ConnectionClosedException;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpException;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpServerConnection;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestHandlerResolver;
import org.apache.http.protocol.HttpService;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.serviio.ApplicationSettings;
import org.serviio.upnp.protocol.http.UniversalHttpServerConnection;
import org.serviio.upnp.protocol.ssdp.SSDPConstants;
import org.serviio.upnp.webserver.DeviceDescriptionRequestHandler;
import org.serviio.upnp.webserver.HttpRequestHandlerRegexRegistry;
import org.serviio.upnp.webserver.ResourceTransportRequestHandler;
import org.serviio.upnp.webserver.ServiceControlRequestHandler;
import org.serviio.upnp.webserver.ServiceDescriptionRequestHandler;
import org.serviio.upnp.webserver.ServiceEventSubscriptionRequestHandler;
import org.serviio.upnp.webserver.ServiioHttpService;
import org.serviio.upnp.webserver.UPnPIconRequestHandler;
import org.serviio.util.MultiCastUtils;
import org.serviio.util.ObjectValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServer {
    private static final Logger log = LoggerFactory.getLogger(WebServer.class);
    private static RequestListenerThread webServerThread;
    public static final Integer WEBSERVER_PORT;
    public static final String CONTEXT_PARAM_REMOTE_IP = "remote_ip_address";
    public static final int DEFAULT_SOCKET_BUFFER = 65535;
    public static int socketBuffer;

    public static void start(int port) throws IOException {
        webServerThread = new RequestListenerThread(port);
        webServerThread.setName("WebServer");
        webServerThread.setDaemon(false);
        webServerThread.start();
    }

    public static void stop() throws IOException {
        if (webServerThread != null) {
            webServerThread.interrupt();
            webServerThread.getServersocket().close();
        }
    }

    public static int getSocketBufferSize() {
        return socketBuffer;
    }

    static {
        WEBSERVER_PORT = ApplicationSettings.getIntegerProperty("webserver_port");
        socketBuffer = ObjectValidator.isNotEmpty(System.getProperty("serviio.socketBuffer")) ? Integer.valueOf(System.getProperty("serviio.socketBuffer")) : 65535;
        log.info(String.format("Socket buffer set to %s bytes", socketBuffer));
    }

    static class WorkerThread
    extends Thread {
        private final HttpService httpservice;
        private final UniversalHttpServerConnection conn;

        public WorkerThread(HttpService httpservice, UniversalHttpServerConnection conn) {
            this.httpservice = httpservice;
            this.conn = conn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String remoteIpAddress = this.conn.getSocketAddress();
            BasicHttpContext context = new BasicHttpContext(null);
            context.setAttribute(WebServer.CONTEXT_PARAM_REMOTE_IP, (Object)remoteIpAddress);
            try {
                while (!Thread.interrupted() && this.conn.isOpen()) {
                    this.httpservice.handleRequest((HttpServerConnection)this.conn, (HttpContext)context);
                    this.conn.closeEntityStream();
                }
                this.conn.close();
            }
            catch (ConnectionClosedException ex) {
                log.trace("Client closed connection");
                this.conn.closeEntityStream();
            }
            catch (IOException ex) {
                log.debug("I/O error: " + ex.getMessage());
                this.conn.closeEntityStream();
            }
            catch (HttpException ex) {
                log.warn("Unrecoverable HTTP protocol violation: " + ex.getMessage());
                this.conn.closeEntityStream();
            }
            finally {
                try {
                    this.conn.shutdown();
                }
                catch (IOException ignore) {}
            }
        }
    }

    static class RequestListenerThread
    extends Thread {
        private final ServerSocket serversocket;
        private final HttpParams params;
        private final HttpService httpService;

        public RequestListenerThread(int port) throws IOException {
            this.serversocket = new ServerSocket(port);
            this.params = new BasicHttpParams();
            this.params.setIntParameter("http.socket.timeout", 0).setIntParameter("http.socket.buffer-size", socketBuffer).setBooleanParameter("http.connection.stalecheck", false).setBooleanParameter("http.tcp.nodelay", true).setParameter("http.origin-server", (Object)SSDPConstants.SERVER);
            BasicHttpProcessor httpproc = new BasicHttpProcessor();
            httpproc.addInterceptor((HttpResponseInterceptor)new ResponseDate());
            httpproc.addInterceptor((HttpResponseInterceptor)new ResponseServer());
            httpproc.addInterceptor((HttpResponseInterceptor)new ResponseContent());
            httpproc.addInterceptor((HttpResponseInterceptor)new ResponseConnControl());
            HttpRequestHandlerRegexRegistry reqistry = new HttpRequestHandlerRegexRegistry();
            reqistry.register(".*/deviceDescription/.+", new DeviceDescriptionRequestHandler());
            reqistry.register(".*/serviceDescription/.+", new ServiceDescriptionRequestHandler());
            reqistry.register(".*/serviceControl", new ServiceControlRequestHandler());
            reqistry.register(".*/serviceEventing/.+", new ServiceEventSubscriptionRequestHandler());
            reqistry.register(".*/resource/.+", new ResourceTransportRequestHandler());
            reqistry.register(".*/icon/.+", new UPnPIconRequestHandler());
            this.httpService = new ServiioHttpService((HttpProcessor)httpproc, (ConnectionReuseStrategy)new DefaultConnectionReuseStrategy(), (HttpResponseFactory)new DefaultHttpResponseFactory());
            this.httpService.setParams(this.params);
            this.httpService.setHandlerResolver((HttpRequestHandlerResolver)reqistry);
        }

        @Override
        public void run() {
            log.info("WebServer starting on port " + this.serversocket.getLocalPort());
            while (!Thread.interrupted()) {
                try {
                    Socket socket = this.serversocket.accept();
                    socket.setSendBufferSize(socketBuffer);
                    if (MultiCastUtils.tosEnabled) {
                        socket.setTrafficClass(24);
                    }
                    UniversalHttpServerConnection conn = new UniversalHttpServerConnection(UUID.randomUUID().toString());
                    conn.bind(socket, this.params);
                    WorkerThread t = new WorkerThread(this.httpService, conn);
                    t.setDaemon(true);
                    t.start();
                }
                catch (InterruptedIOException ex) {
                    break;
                }
                catch (SocketException e) {
                    log.debug("Socket closed");
                }
                catch (IOException e) {
                    log.error(String.format("I/O error initialising connection thread: %s", e.getMessage()), (Throwable)e);
                    break;
                }
            }
            log.info("WebServer shutting down");
        }

        public ServerSocket getServersocket() {
            return this.serversocket;
        }
    }
}

