/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.webserver;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.protocol.HttpContext;
import org.serviio.upnp.webserver.AbstractDescriptionRequestHandler;
import org.serviio.util.FileUtils;

public class UPnPIconRequestHandler
extends AbstractDescriptionRequestHandler {
    public static final String LARGE_PNG = "largePNG";
    public static final String SMALL_PNG = "smallPNG";
    public static final String LARGE_JPG = "largeJPG";
    public static final String SMALL_JPG = "smallJPG";
    private static final Map<String, IconDescription> icons = new HashMap<String, IconDescription>();

    @Override
    protected void handleRequest(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        String[] requestFields = UPnPIconRequestHandler.getRequestPathFields(this.getRequestUri(request), "/icon", null);
        if (requestFields.length > 1) {
            response.setStatusCode(404);
            return;
        }
        String iconName = requestFields[0];
        if (iconName != null) {
            this.log.debug(String.format("UPnP icon request received for icon %s", iconName));
            IconDescription id = icons.get(iconName);
            if (id != null) {
                byte[] iconBytes = FileUtils.readFileBytes(this.getClass().getResourceAsStream("/org/serviio/upnp/" + id.getFileName()));
                ByteArrayEntity icon = new ByteArrayEntity(iconBytes);
                icon.setContentType(id.getMimeType());
                response.setEntity((HttpEntity)icon);
                return;
            }
        }
        response.setStatusCode(404);
        this.log.debug(String.format("Icon with id %s doesn't exist, sending back 404 error", iconName));
    }

    static {
        try {
            icons.put(SMALL_JPG, new IconDescription("image/jpeg", "serviio-icon-small.jpg"));
            icons.put(LARGE_JPG, new IconDescription("image/jpeg", "serviio-icon-large.jpg"));
            icons.put(SMALL_PNG, new IconDescription("image/png", "serviio-icon-small.png"));
            icons.put(LARGE_PNG, new IconDescription("image/png", "serviio-icon-large.png"));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private static class IconDescription {
        private String mimeType;
        private String fileName;

        public IconDescription(String mimeType, String fileName) throws URISyntaxException {
            this.mimeType = mimeType;
            this.fileName = fileName;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

