/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.webserver;

import java.io.IOException;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpService;
import org.serviio.util.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiioHttpService
extends HttpService {
    private static final Logger log = LoggerFactory.getLogger(ServiioHttpService.class);

    public ServiioHttpService(HttpProcessor proc, ConnectionReuseStrategy connStrategy, HttpResponseFactory responseFactory) {
        super(proc, connStrategy, responseFactory);
    }

    protected void doService(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Incoming request from %s: %s", context.getAttribute("remote_ip_address"), HttpUtils.requestToString(request)));
        }
        super.doService(request, response, context);
        if (response.getStatusLine().getStatusCode() == 501) {
            response.setStatusCode(404);
        }
    }
}

