/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.webserver;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.protocol.HttpContext;
import org.serviio.upnp.Device;
import org.serviio.upnp.eventing.EventDispatcher;
import org.serviio.upnp.eventing.Subscription;
import org.serviio.upnp.service.Service;
import org.serviio.upnp.webserver.AbstractRequestHandler;
import org.serviio.util.ObjectValidator;
import org.serviio.util.StringUtils;

public class ServiceEventSubscriptionRequestHandler
extends AbstractRequestHandler {
    @Override
    protected void checkMethod(HttpRequest request) throws MethodNotSupportedException {
        String method = StringUtils.localeSafeToUppercase(request.getRequestLine().getMethod());
        if (!method.equals("SUBSCRIBE") && !method.equals("UNSUBSCRIBE")) {
            throw new MethodNotSupportedException(method + " method not supported");
        }
    }

    @Override
    protected void handleRequest(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        String[] requestFields = ServiceEventSubscriptionRequestHandler.getRequestPathFields(this.getRequestUri(request), "/serviceEventing", null);
        String serviceShortName = requestFields[0];
        if (serviceShortName != null) {
            Service service = Device.getInstance().getServiceByShortName(serviceShortName);
            if (service != null) {
                String method = StringUtils.localeSafeToUppercase(request.getRequestLine().getMethod());
                Header subscriptionId = request.getFirstHeader("SID");
                Header notificationType = request.getFirstHeader("NT");
                Header callback = request.getFirstHeader("CALLBACK");
                Header timeout = request.getFirstHeader("TIMEOUT");
                if (subscriptionId != null && (notificationType != null || callback != null)) {
                    response.setStatusCode(400);
                } else {
                    String sid;
                    String string = sid = subscriptionId != null ? subscriptionId.getValue() : null;
                    if (method.equals("SUBSCRIBE")) {
                        if (notificationType != null) {
                            this.log.debug(String.format("ServiceEvent subscription request received for service %s", serviceShortName));
                            this.subscriptionSetup(response, service, notificationType, callback, timeout == null ? null : this.resolveTimeout(timeout.getValue()));
                        } else {
                            this.log.debug(String.format("ServiceEvent renewal request received for service %s and subscription %s", serviceShortName, sid));
                            this.subscriptionRenewal(response, service, subscriptionId, timeout == null ? null : this.resolveTimeout(timeout.getValue()));
                        }
                    } else {
                        this.log.debug(String.format("ServiceEvent unsubscription request received for service %s and subscription %s", serviceShortName, sid));
                        this.subscriptionCancellation(response, service, subscriptionId);
                    }
                }
            } else {
                this.log.warn(String.format("Requested service %s doesn't exist", serviceShortName));
                response.setStatusCode(503);
            }
        } else {
            this.log.warn("No service specified for subscription");
            response.setStatusCode(503);
        }
    }

    private void subscriptionRenewal(HttpResponse response, Service service, Header subscriptionId, String timeout) {
        if (subscriptionId == null || ObjectValidator.isEmpty(subscriptionId.getValue())) {
            response.setStatusCode(412);
            return;
        }
        String subscriptionUUID = subscriptionId.getValue().trim().substring(5);
        Subscription subscription = service.getEventSubscription(subscriptionUUID);
        if (subscription == null) {
            response.setStatusCode(412);
            return;
        }
        subscription.setCreated(new Date());
        if (timeout != null) {
            subscription.setDuration(timeout);
        }
        this.log.debug(String.format("Event subscription renewed for service %s and subscription %s", service.getServiceId(), subscriptionUUID));
        this.generateSuccessfulSubscriptionResponse(response, subscription);
    }

    private void subscriptionSetup(HttpResponse response, Service service, Header notificationType, Header callback, String timeout) {
        if (notificationType.getValue() == null || ObjectValidator.isEmpty(notificationType.getValue()) || !notificationType.getValue().trim().equals("upnp:event")) {
            response.setStatusCode(412);
            return;
        }
        if (callback == null || ObjectValidator.isEmpty(callback.getValue())) {
            response.setStatusCode(412);
            return;
        }
        URL deliveryURL = null;
        try {
            deliveryURL = new URL(this.getDeliveryURL(callback.getValue()));
        }
        catch (MalformedURLException e) {
            response.setStatusCode(412);
            return;
        }
        Subscription subscription = service.getEventSubscription(deliveryURL);
        if (subscription != null) {
            this.log.debug(String.format("Event subscription reused (uuid=%s) for service %s reporting to %s", subscription.getUuid(), service.getServiceId(), deliveryURL.toString()));
        } else {
            subscription = new Subscription();
            subscription.setDeliveryURL(deliveryURL);
            subscription.setCreated(new Date());
            if (timeout == null) {
                timeout = Integer.toString(300);
            }
            subscription.setDuration(timeout);
            service.addEventSubscription(subscription);
            this.log.debug(String.format("Event subscription registered (uuid=%s) for service %s with duration %s reporting to %s", subscription.getUuid(), service.getServiceId(), timeout, deliveryURL.toString()));
        }
        this.generateSuccessfulSubscriptionResponse(response, subscription);
        EventDispatcher.addInitialEvents(service, service.getStateVariablesWithEventing(), subscription);
    }

    private void subscriptionCancellation(HttpResponse response, Service service, Header subscriptionId) {
        if (subscriptionId == null || ObjectValidator.isEmpty(subscriptionId.getValue())) {
            response.setStatusCode(412);
            return;
        }
        String subscriptionUUID = subscriptionId.getValue().trim().substring(5);
        Subscription subscription = service.getEventSubscription(subscriptionUUID);
        if (subscription == null) {
            response.setStatusCode(412);
            return;
        }
        service.removeEventSubscription(subscription);
        this.log.debug(String.format("Event subscription (uuid=%s) removed for service %s", subscriptionUUID, service.getServiceId()));
        response.setStatusCode(200);
    }

    private void generateSuccessfulSubscriptionResponse(HttpResponse response, Subscription subscription) {
        response.setStatusCode(200);
        response.setHeader("SID", "uuid:" + subscription.getUuid());
        response.setHeader("TIMEOUT", "Second-" + subscription.getDuration());
    }

    private String resolveTimeout(String timeoutHeader) {
        int offset;
        if (timeoutHeader != null && (offset = StringUtils.localeSafeToUppercase(timeoutHeader).indexOf("SECOND-")) > -1) {
            String seconds = timeoutHeader.substring(7, timeoutHeader.length());
            return seconds;
        }
        return null;
    }

    private String getDeliveryURL(String callback) {
        String[] urls;
        for (String item : urls = callback.split("<|>")) {
            if (item == null || item.equals("")) continue;
            return item;
        }
        return null;
    }
}

