/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.webserver;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;
import org.serviio.upnp.Device;
import org.serviio.upnp.protocol.TemplateApplicator;
import org.serviio.upnp.service.Service;
import org.serviio.upnp.webserver.AbstractDescriptionRequestHandler;

public class ServiceDescriptionRequestHandler
extends AbstractDescriptionRequestHandler {
    @Override
    protected void handleRequest(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        String[] requestFields = ServiceDescriptionRequestHandler.getRequestPathFields(this.getRequestUri(request), "/serviceDescription", null);
        String serviceShortName = requestFields[0];
        if (serviceShortName != null) {
            this.log.debug(String.format("ServiceDescription request received for service %s", serviceShortName));
            Device device = Device.getInstance();
            Service service = device.getServiceByShortName(serviceShortName);
            if (service != null) {
                String message = null;
                if (service.getServiceType().equals("urn:schemas-upnp-org:service:ConnectionManager:1")) {
                    message = TemplateApplicator.applyTemplate("org/serviio/upnp/protocol/templates/serviceDescription-ConnectionManager.ftl", null);
                } else if (service.getServiceType().equals("urn:schemas-upnp-org:service:ContentDirectory:1")) {
                    message = TemplateApplicator.applyTemplate("org/serviio/upnp/protocol/templates/serviceDescription-ContentDirectory.ftl", null);
                } else if (service.getServiceType().equals("urn:microsoft.com:service:X_MS_MediaReceiverRegistrar:1")) {
                    message = TemplateApplicator.applyTemplate("org/serviio/upnp/protocol/templates/serviceDescription-MediaReceiverRegistrar.ftl", null);
                }
                if (message != null) {
                    this.prepareSuccessfulHttpResponse(request, response);
                    StringEntity body = new StringEntity(message, "UTF-8");
                    body.setContentType("text/xml");
                    response.setEntity((HttpEntity)body);
                    this.log.debug("Sending ServiceDescription XML back");
                } else {
                    response.setStatusCode(404);
                    this.log.debug(String.format("Service with name %s is not supported, sending back 404 error", serviceShortName));
                }
            } else {
                response.setStatusCode(404);
                this.log.debug(String.format("Service with name %s doesn't exist in the root device, sending back 404 error", serviceShortName));
            }
        }
    }
}

