/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.webserver;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.serviio.renderer.RendererManager;
import org.serviio.renderer.entities.Renderer;
import org.serviio.upnp.protocol.soap.ServiceInvocationException;
import org.serviio.upnp.protocol.soap.ServiceInvoker;
import org.serviio.upnp.webserver.AbstractRequestHandler;
import org.serviio.util.StringUtils;

public class ServiceControlRequestHandler
extends AbstractRequestHandler {
    @Override
    protected void checkMethod(HttpRequest request) throws MethodNotSupportedException {
        String method = StringUtils.localeSafeToUppercase(request.getRequestLine().getMethod());
        if (!method.equals("POST")) {
            throw new MethodNotSupportedException(method + " method not supported");
        }
    }

    @Override
    protected void handleRequest(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        String soapAction = request.getFirstHeader("SOAPACTION").getValue();
        InetAddress clientIPAddress = this.getCallerIPAddress(context);
        this.log.debug(String.format("ServiceControl request received for action '%s' from %s", soapAction, clientIPAddress.getHostAddress()));
        if (request instanceof HttpEntityEnclosingRequest) {
            Renderer renderer = RendererManager.getInstance().getStoredRendererByIPAddress(clientIPAddress);
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            String entityContent = EntityUtils.toString((HttpEntity)entity);
            try {
                SOAPMessage resultSOAPMessage = ServiceInvoker.invokeService(soapAction, entityContent, renderer);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                try {
                    resultSOAPMessage.writeTo((OutputStream)outputStream);
                    if (resultSOAPMessage.getSOAPBody().hasFault()) {
                        response.setStatusCode(500);
                        this.log.debug("Returning error SOAP message");
                    } else {
                        response.setStatusCode(200);
                        this.log.debug("Returning OK SOAP message");
                    }
                    response.addHeader("EXT", "");
                    StringEntity body = new StringEntity(outputStream.toString("UTF-8"), "UTF-8");
                    body.setContentType("text/xml; charset=\"utf-8\"");
                    response.setEntity((HttpEntity)body);
                }
                catch (SOAPException e) {
                    this.log.error("Cannot write retrieve SOAP response message", (Throwable)e);
                    response.setStatusCode(500);
                }
            }
            catch (ServiceInvocationException e) {
                this.log.error(String.format("Cannot process control request: %s", e.getMessage()), (Throwable)e);
                response.setStatusCode(500);
            }
        } else {
            this.log.error("HttpRequest doesn't contain any SOAP message");
            response.setStatusCode(500);
        }
    }
}

