/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.webserver;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.ProtocolVersion;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.protocol.HttpContext;
import org.serviio.delivery.Client;
import org.serviio.delivery.HostInfo;
import org.serviio.delivery.HttpDeliveryContainer;
import org.serviio.delivery.HttpResponseCodeException;
import org.serviio.delivery.RangeHeaders;
import org.serviio.delivery.ResourceDeliveryProcessor;
import org.serviio.delivery.ResourceRetrievalStrategyFactory;
import org.serviio.profile.Profile;
import org.serviio.profile.ProfileManager;
import org.serviio.upnp.protocol.http.transport.DLNAProtocolHandler;
import org.serviio.upnp.protocol.http.transport.ResourceTransportProtocolHandler;
import org.serviio.upnp.webserver.AbstractRequestHandler;
import org.serviio.util.CaseInsensitiveMap;
import org.serviio.util.HttpUtils;
import org.serviio.util.StringUtils;

public class ResourceTransportRequestHandler
extends AbstractRequestHandler {
    private static final ResourceRetrievalStrategyFactory resourceRetrievalStrategyFactory = new ResourceRetrievalStrategyFactory();
    private ResourceTransportProtocolHandler dlnaProtocolHandler = new DLNAProtocolHandler();

    @Override
    protected void handleRequest(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        try {
            ResourceDeliveryProcessor.HttpMethod method = ResourceDeliveryProcessor.HttpMethod.valueOf(StringUtils.localeSafeToUppercase(request.getRequestLine().getMethod()));
            InetAddress clientIPAddress = this.getCallerIPAddress(context);
            Profile rendererProfile = ProfileManager.getProfile(clientIPAddress);
            Client client = new Client(clientIPAddress.getHostAddress(), rendererProfile, HostInfo.defaultHostInfo());
            String requestUri = this.getRequestUri(request);
            Map<String, String> requestHeadersMap = this.getRequestHeadersMap(request);
            HttpDeliveryContainer container = new ResourceDeliveryProcessor(resourceRetrievalStrategyFactory).deliverContent(requestUri, method, this.getHttpVersion(), requestHeadersMap, this.parseRangeHeaders(requestHeadersMap), this.getProtocolHandler(client), client);
            if (method == ResourceDeliveryProcessor.HttpMethod.GET) {
                response.setEntity(this.createHttpEntity(container));
            }
            this.saveResponseHeaders(container.getResponseHeaders(), response);
            if (container.isPartialContent()) {
                response.setStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 206);
            } else {
                response.setStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 200);
            }
            this.log.debug(HttpUtils.responseToString(response));
        }
        catch (HttpResponseCodeException e) {
            response.setStatusCode(e.getHttpCode());
        }
        catch (Exception e) {
            response.setStatusCode(500);
            this.log.error(String.format("Error while processing resource, sending back 500 error. Message: %s", e.getMessage()), (Throwable)e);
        }
    }

    @Override
    protected void checkMethod(HttpRequest request) throws MethodNotSupportedException {
        String method = StringUtils.localeSafeToUppercase(request.getRequestLine().getMethod());
        if (!method.equals("GET") && !method.equals("HEAD")) {
            throw new MethodNotSupportedException(method + " method not supported");
        }
    }

    private Map<String, String> getRequestHeadersMap(HttpRequest request) {
        CaseInsensitiveMap<String> headers = new CaseInsensitiveMap<String>();
        for (Header header : request.getAllHeaders()) {
            headers.put(header.getName(), header.getValue());
        }
        return headers;
    }

    private RangeHeaders parseRangeHeaders(Map<String, String> headers) throws HttpResponseCodeException {
        String rangeHeader = headers.get("Range");
        String timeSeekHeader = headers.get("TimeSeekRange.dlna.org");
        try {
            return RangeHeaders.parseHttpRange(RangeHeaders.RangeDefinition.DLNA, rangeHeader, timeSeekHeader);
        }
        catch (NumberFormatException e) {
            this.log.debug("Unsupported range request, sending back 400");
            throw new HttpResponseCodeException(400);
        }
    }

    private void saveResponseHeaders(Map<String, Object> headers, HttpResponse response) {
        for (Map.Entry<String, Object> header : headers.entrySet()) {
            response.addHeader(header.getKey(), header.getValue().toString());
        }
    }

    private ResourceTransportProtocolHandler getProtocolHandler(Client client) {
        ResourceTransportProtocolHandler protocolHandler = client.getRendererProfile().getResourceTransportProtocolHandler();
        if (protocolHandler != null) {
            return protocolHandler;
        }
        return this.dlnaProtocolHandler;
    }

    private HttpEntity createHttpEntity(HttpDeliveryContainer container) {
        InputStreamEntity fileEntity = new InputStreamEntity(container.getContentStream(), container.getFileSize().longValue());
        if (DLNAProtocolHandler.isChunked(container.getTransferMode(), container.getRequestHttpVersion(), container.isTranscoded())) {
            fileEntity.setChunked(true);
            this.log.debug("Creating entity with chunked transfer");
        }
        return fileEntity;
    }
}

