/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.webserver;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerResolver;

public class HttpRequestHandlerRegexRegistry
implements HttpRequestHandlerResolver {
    private Map<String, HttpRequestHandler> handlers = new HashMap<String, HttpRequestHandler>();
    private Map<String, Pattern> patterns = new HashMap<String, Pattern>();

    public HttpRequestHandler lookup(String uri) {
        for (String pattern : this.patterns.keySet()) {
            if (!this.patterns.get(pattern).matcher(Matcher.quoteReplacement(uri)).matches()) continue;
            return this.handlers.get(pattern);
        }
        return null;
    }

    public void register(String pattern, HttpRequestHandler handler) {
        if (pattern == null) {
            throw new IllegalArgumentException("URI request pattern may not be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("Request handler may not be null");
        }
        this.handlers.put(pattern, handler);
        this.patterns.put(pattern, Pattern.compile(pattern));
    }

    public void unregister(String pattern) {
        this.handlers.remove(pattern);
        this.patterns.remove(pattern);
    }
}

