/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.webserver;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;
import org.serviio.profile.Profile;
import org.serviio.profile.ProfileManager;
import org.serviio.renderer.RendererManager;
import org.serviio.upnp.Device;
import org.serviio.upnp.protocol.TemplateApplicator;
import org.serviio.upnp.webserver.AbstractDescriptionRequestHandler;
import org.serviio.upnp.webserver.WebServer;
import org.serviio.util.HttpUtils;

public class DeviceDescriptionRequestHandler
extends AbstractDescriptionRequestHandler {
    @Override
    protected void handleRequest(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        String[] requestFields = DeviceDescriptionRequestHandler.getRequestPathFields(this.getRequestUri(request), "/deviceDescription", null);
        if (requestFields.length > 1) {
            response.setStatusCode(404);
            return;
        }
        String deviceId = requestFields[0];
        InetAddress clientIPAddress = this.getCallerIPAddress(context);
        this.log.debug(String.format("DeviceDescription request received for device %s from %s (headers = %s)", deviceId, clientIPAddress.getHostAddress(), HttpUtils.headersToString(request.getAllHeaders())));
        if (!clientIPAddress.isLoopbackAddress()) {
            RendererManager.getInstance().rendererAvailable(request.getAllHeaders(), clientIPAddress.getHostAddress());
        }
        Device device = Device.getInstance();
        if (deviceId != null && deviceId.equals(device.getUuid())) {
            Profile profile = ProfileManager.getProfile(clientIPAddress);
            this.prepareSuccessfulHttpResponse(request, response);
            HashMap<String, Object> dataModel = new HashMap<String, Object>();
            dataModel.put("device", device);
            dataModel.put("deviceDescription", profile.getDeviceDescription());
            dataModel.put("services", device.getServices());
            dataModel.put("smallPngURL", this.resolveIconURL("smallPNG"));
            dataModel.put("largePngURL", this.resolveIconURL("largePNG"));
            dataModel.put("smallJpgURL", this.resolveIconURL("smallJPG"));
            dataModel.put("largeJpgURL", this.resolveIconURL("largeJPG"));
            String message = TemplateApplicator.applyTemplate("org/serviio/upnp/protocol/templates/deviceDescription.ftl", dataModel);
            StringEntity body = new StringEntity(message, "UTF-8");
            body.setContentType("text/xml");
            response.setEntity((HttpEntity)body);
            this.log.debug(String.format("Sending DeviceDescription XML back using profile '%s'", profile));
        } else {
            response.setStatusCode(404);
            this.log.debug(String.format("Device with id %s doesn't exist, sending back 404 error", deviceId));
        }
    }

    protected String resolveIconURL(String iconName) {
        try {
            return new URL("http", Device.getInstance().getBindAddress().getHostAddress(), WebServer.WEBSERVER_PORT, "/icon/" + iconName).getPath();
        }
        catch (MalformedURLException e) {
            this.log.warn("Cannot resolve Device UPnP icon URL address.");
            return null;
        }
    }
}

