/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.webserver;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.ProtocolVersion;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.serviio.renderer.RendererManager;
import org.serviio.upnp.Device;
import org.serviio.util.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRequestHandler
implements HttpRequestHandler {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private Map<String, String> urlParameters;
    private ProtocolVersion httpVersion;

    public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        if (this.callerHasAccess(context)) {
            this.httpVersion = request.getRequestLine().getProtocolVersion();
            this.checkMethod(request);
            this.urlParameters = this.getQueryParameters(request);
            this.handleRequest(request, response, context);
        } else {
            response.setStatusCode(403);
        }
    }

    protected abstract void handleRequest(HttpRequest var1, HttpResponse var2, HttpContext var3) throws HttpException, IOException;

    protected abstract void checkMethod(HttpRequest var1) throws MethodNotSupportedException;

    public static String[] getRequestPathFields(String requestUri, String rootContext, Pattern patternToRemove) {
        String uri = requestUri;
        if (patternToRemove != null) {
            uri = patternToRemove.matcher(uri).replaceAll("");
        }
        uri = uri.substring(uri.indexOf(rootContext) + rootContext.length() + 1);
        return HttpUtils.urlDecode(uri).split("/");
    }

    private Map<String, String> getQueryParameters(HttpRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String query = new URI(request.getRequestLine().getUri()).getQuery();
            if (query != null) {
                String[] params;
                for (String param : params = query.split("&")) {
                    String name = param.split("=")[0];
                    String value = param.split("=")[1];
                    map.put(name, value);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    protected String getUserAgent(HttpRequest request) {
        Header userAgentHeader = request.getFirstHeader("User-Agent");
        String userAgent = userAgentHeader != null ? userAgentHeader.getValue() : null;
        return userAgent;
    }

    protected InetAddress getCallerIPAddress(HttpContext context) {
        try {
            String remoteIPAddress = (String)context.getAttribute("remote_ip_address");
            if (remoteIPAddress != null) {
                remoteIPAddress = remoteIPAddress.replaceAll("(^/)|(:.*)", "");
                return InetAddress.getByName(remoteIPAddress);
            }
            return Device.getInstance().getBindAddress();
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid incoming IP address, cannot identify the client.");
        }
    }

    protected String getRequestUri(HttpRequest request) {
        return request.getRequestLine().getUri().trim();
    }

    private boolean callerHasAccess(HttpContext context) {
        InetAddress callerIp = this.getCallerIPAddress(context);
        boolean hasAccess = RendererManager.getInstance().rendererHasAccess(callerIp);
        if (!hasAccess) {
            this.log.debug(String.format("Device %s does not have access to the server, returning 403", callerIp.toString()));
        }
        return hasAccess;
    }

    protected final Map<String, String> getUrlParameters() {
        return this.urlParameters;
    }

    protected ProtocolVersion getHttpVersion() {
        return this.httpVersion;
    }
}

