/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.webserver;

import java.util.Date;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.MethodNotSupportedException;
import org.serviio.upnp.webserver.AbstractRequestHandler;
import org.serviio.util.DateUtils;
import org.serviio.util.StringUtils;

public abstract class AbstractDescriptionRequestHandler
extends AbstractRequestHandler {
    @Override
    protected void checkMethod(HttpRequest request) throws MethodNotSupportedException {
        String method = StringUtils.localeSafeToUppercase(request.getRequestLine().getMethod());
        if (!method.equals("GET")) {
            throw new MethodNotSupportedException(method + " method not supported");
        }
    }

    protected void prepareSuccessfulHttpResponse(HttpRequest request, HttpResponse response) {
        Header acceptLanguageHeader = request.getFirstHeader("ACCEPT-LANGUAGE");
        response.setStatusCode(200);
        if (acceptLanguageHeader != null && acceptLanguageHeader.getValue() != null) {
            response.addHeader("CONTENT-LANGUAGE", "en-gb");
        }
        response.addHeader("DATE", DateUtils.formatRFC1123(new Date()));
    }
}

