/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory.rest.resources.server;

import java.security.MessageDigest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.restlet.Request;
import org.restlet.representation.StringRepresentation;
import org.serviio.upnp.service.contentdirectory.rest.resources.FlowPlayerKeyGeneratorResource;
import org.serviio.upnp.service.contentdirectory.rest.resources.server.AbstractRestrictedCDSServerResource;
import org.serviio.util.SecurityUtils;

public class FlowPlayerKeyGeneratorServerResource
extends AbstractRestrictedCDSServerResource
implements FlowPlayerKeyGeneratorResource {
    private static final String PRIVATE_KEY = "8935e021454f50d9a18";
    private static final Pattern DOMAIN_MATCHER = Pattern.compile("^.*\\.(.+\\..+)$");

    @Override
    public StringRepresentation generate() {
        Request request = this.getRequest();
        String domain = this.getSubDomain(request.getReferrerRef().getHostDomain(true));
        this.log.debug(String.format("Generating security key for domain '%s'", domain));
        return new StringRepresentation((CharSequence)this.generateKey(domain));
    }

    protected String getSubDomain(String host) {
        this.log.debug(String.format("RefererRef of the incoming request is '%s'", host));
        Matcher m = DOMAIN_MATCHER.matcher(host);
        if (m.matches() && m.groupCount() == 1) {
            return m.group(1);
        }
        return host;
    }

    protected String generateKey(String domain) {
        String toEncode = String.format("%s%s", domain, PRIVATE_KEY);
        try {
            byte[] bytesOfMessage = toEncode.getBytes("UTF-8");
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] thedigest = md.digest(bytesOfMessage);
            return SecurityUtils.byteArrayToHex(thedigest).substring(11, 30);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

