/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory.rest.resources.server;

import java.util.ArrayList;
import java.util.List;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.library.search.SearchManager;
import org.serviio.library.search.SearchResult;
import org.serviio.library.search.SearchResultsHolder;
import org.serviio.restlet.HttpCodeException;
import org.serviio.upnp.service.contentdirectory.ObjectType;
import org.serviio.upnp.service.contentdirectory.rest.representation.AbstractCDSObjectRepresentation;
import org.serviio.upnp.service.contentdirectory.rest.representation.CategorySearchResultsRepresentation;
import org.serviio.upnp.service.contentdirectory.rest.representation.SearchResultRepresentation;
import org.serviio.upnp.service.contentdirectory.rest.representation.SearchResultsRepresentation;
import org.serviio.upnp.service.contentdirectory.rest.resources.CDSSearchResource;
import org.serviio.upnp.service.contentdirectory.rest.resources.server.AbstractRestrictedCDSServerResource;
import org.serviio.util.HttpUtils;
import org.serviio.util.StringUtils;

public class CDSSearchServerResource
extends AbstractRestrictedCDSServerResource
implements CDSSearchResource {
    private int startIndex;
    private int count;
    private MediaFileType fileType;
    private String term;
    private String profileId;

    @Override
    public SearchResultsRepresentation search() {
        try {
            ArrayList<CategorySearchResultsRepresentation> categoryResults = new ArrayList<CategorySearchResultsRepresentation>();
            List<SearchResultsHolder> results = SearchManager.getInstance().searcher().search(this.term, this.fileType, this.startIndex, this.count);
            for (SearchResultsHolder holder : results) {
                ArrayList<SearchResultRepresentation> items = new ArrayList<SearchResultRepresentation>();
                for (SearchResult sr : holder.getItems()) {
                    AbstractCDSObjectRepresentation.DirectoryObjectType objectType = sr.getObjectType() == ObjectType.ITEMS ? AbstractCDSObjectRepresentation.DirectoryObjectType.ITEM : AbstractCDSObjectRepresentation.DirectoryObjectType.CONTAINER;
                    SearchResultRepresentation rr = new SearchResultRepresentation(objectType, sr.getTitle(), sr.getCdsObjectId());
                    rr.setParentId(sr.getCdsParentId());
                    rr.setFileType(sr.getFileType());
                    rr.setThumbnailUrl(this.getResourceUrl(sr.getThumbnail(), this.profileId));
                    rr.setContext(sr.getContext());
                    items.add(rr);
                }
                CategorySearchResultsRepresentation srr = new CategorySearchResultsRepresentation();
                srr.setCategory(holder.getCategory());
                srr.setReturnedSize(holder.getReturnedSize());
                srr.setTotalMatched(holder.getTotalMatched());
                srr.setObjects(items);
                categoryResults.add(srr);
            }
            SearchResultsRepresentation result = new SearchResultsRepresentation();
            result.setCategoryResults(categoryResults);
            result.setTerm(this.term);
            return result;
        }
        catch (Exception e) {
            this.log.warn(String.format("Search for term '%s' failed with exception: %s", this.term, e.getMessage()), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.term = HttpUtils.urlDecode((String)this.getRequestAttributes().get("term"));
        this.profileId = (String)this.getRequestAttributes().get("profile");
        this.startIndex = Integer.parseInt((String)this.getRequestAttributes().get("start"));
        this.count = Integer.parseInt((String)this.getRequestAttributes().get("count"));
        this.fileType = this.getFileType((String)this.getRequestAttributes().get("fileType"));
        if (this.count == 0) {
            this.count = 100;
        }
    }

    private MediaFileType getFileType(String identifier) {
        String id = StringUtils.localeSafeToLowercase(identifier.trim());
        if (id.equals("i")) {
            return MediaFileType.IMAGE;
        }
        if (id.equals("v")) {
            return MediaFileType.VIDEO;
        }
        if (id.equals("a")) {
            return MediaFileType.AUDIO;
        }
        throw new HttpCodeException(Status.CLIENT_ERROR_BAD_REQUEST.getCode(), "Invalid file type: " + identifier);
    }
}

