/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory.rest.resources.server;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.restlet.Request;
import org.restlet.data.CacheDirective;
import org.restlet.data.MediaType;
import org.restlet.data.Range;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StreamRepresentation;
import org.serviio.delivery.Client;
import org.serviio.delivery.HttpDeliveryContainer;
import org.serviio.delivery.HttpResponseCodeException;
import org.serviio.delivery.RangeHeaders;
import org.serviio.delivery.ResourceDeliveryProcessor;
import org.serviio.delivery.ResourceRetrievalStrategyFactory;
import org.serviio.profile.Profile;
import org.serviio.profile.ProfileManager;
import org.serviio.restlet.HttpCodeException;
import org.serviio.upnp.protocol.http.transport.CDSProtocolHandler;
import org.serviio.upnp.service.contentdirectory.classes.Resource;
import org.serviio.upnp.service.contentdirectory.rest.representation.ClosingInputRepresentation;
import org.serviio.upnp.service.contentdirectory.rest.resources.CDSRetrieveMediaResource;
import org.serviio.upnp.service.contentdirectory.rest.resources.server.AbstractRestrictedCDSServerResource;
import org.serviio.util.HttpUtils;
import org.serviio.util.ObjectValidator;

public class CDSRetrieveMediaServerResource
extends AbstractRestrictedCDSServerResource
implements CDSRetrieveMediaResource {
    private static final int CACHE_SECONDS = 36000;
    public static final String RESOURCE_CONTEXT = "/resource";
    private static final String PARAM_CLIENT_ID = "clientId";
    private static final ResourceRetrievalStrategyFactory resourceRetrievalStrategyFactory = new ResourceRetrievalStrategyFactory();
    private Profile profile;

    @Override
    public StreamRepresentation deliver() throws IOException {
        Request request = this.getRequest();
        this.log.debug(request.toString() + ", headers = " + HttpUtils.headersToString(this.getRequestHeaders(this.getRequest())));
        ResourceDeliveryProcessor processor = new ResourceDeliveryProcessor(resourceRetrievalStrategyFactory);
        this.storeProfileFromPath();
        String normalizedPath = request.getOriginalRef().getPath();
        try {
            Map<String, String> requestHeaders = this.getRequestHeaders(request);
            HttpDeliveryContainer container = processor.deliverContent(normalizedPath, ResourceDeliveryProcessor.HttpMethod.GET, (ProtocolVersion)(this.getProtocol().getVersion().equals("1.1") ? HttpVersion.HTTP_1_1 : HttpVersion.HTTP_1_0), requestHeaders, this.parseRequestRangeHeaders(requestHeaders, request), new CDSProtocolHandler(), this.getClient(requestHeaders));
            ClosingInputRepresentation rep = new ClosingInputRepresentation(container.getContentStream(), this.getMediaType(container.getResponseHeaders()), this.getFullStreamSize(container), this.getDeliveredStreamSize(container), this.getRequest());
            this.getResponse().setEntity((Representation)rep);
            this.getResponse().setDimensions(null);
            if (container.isPartialContent()) {
                this.setRange(container.getResponseHeaders());
            }
            if (!container.isTranscoded()) {
                this.getResponse().getServerInfo().setAcceptingRanges(true);
            }
            this.getResponse().setStatus(container.isPartialContent() ? Status.SUCCESS_PARTIAL_CONTENT : Status.SUCCESS_OK);
            if (normalizedPath.indexOf(Resource.ResourceType.COVER_IMAGE.toString()) > -1) {
                this.getResponse().setCacheDirectives(Arrays.asList(new CacheDirective(String.format("private, max-age=%s", 36000))));
            }
            return rep;
        }
        catch (HttpResponseCodeException e) {
            throw new HttpCodeException(e.getHttpCode(), e.getMessage(), e.getCause());
        }
    }

    private void storeProfileFromPath() {
        String profile = this.getRequestQueryParam("profile");
        if (ObjectValidator.isNotEmpty(profile)) {
            this.profile = ProfileManager.getProfileById(profile);
            if (this.profile != null) {
                return;
            }
        }
        this.log.warn("Request doesn't include profile id or the profile is invalid");
        throw new HttpCodeException(400);
    }

    private Client getClient(Map<String, String> requestHeaders) {
        String clientId = this.getRequestQueryParam(PARAM_CLIENT_ID);
        if (ObjectValidator.isEmpty(clientId)) {
            clientId = this.getHeaderStringValue("X-Serviio-ClientId", requestHeaders);
        }
        if (ObjectValidator.isEmpty(clientId)) {
            clientId = this.getClientInfo().getAddress();
        }
        this.log.debug(String.format("Creating client with id '%s'", clientId));
        Client c = new Client(clientId, this.profile, this.getHostInfo(true, true, this.profile.getId()));
        c.setExpectsClosedConnection(true);
        c.setSupportsRandomTimeSeek(true);
        return c;
    }

    private void setRange(Map<String, Object> headers) {
        RangeHeaders range = this.getResponseRangeHeader(headers);
        if (range != null) {
            if (range.hasHeaders(RangeHeaders.RangeUnit.BYTES)) {
                this.getResponse().getEntity().setRange(new Range(range.getStartAsLong(RangeHeaders.RangeUnit.BYTES).longValue(), range.getEndAsLong(RangeHeaders.RangeUnit.BYTES) - range.getStartAsLong(RangeHeaders.RangeUnit.BYTES) + 1L));
            }
            if (range.hasHeaders(RangeHeaders.RangeUnit.SECONDS)) {
                Range rangeHeader = new Range(range.getStartAsLong(RangeHeaders.RangeUnit.SECONDS).longValue(), range.getEndAsLong(RangeHeaders.RangeUnit.SECONDS) - range.getStartAsLong(RangeHeaders.RangeUnit.SECONDS));
                rangeHeader.setUnitName("seconds");
                rangeHeader.setTotalSize(range.getTotal(RangeHeaders.RangeUnit.SECONDS));
                this.getResponse().getEntity().setRange(rangeHeader);
            }
        }
    }

    private RangeHeaders getResponseRangeHeader(Map<String, Object> headers) {
        RangeHeaders range = (RangeHeaders)headers.get("Content-Range");
        return range;
    }

    private long getFullStreamSize(HttpDeliveryContainer container) {
        RangeHeaders range = this.getResponseRangeHeader(container.getResponseHeaders());
        if (container.isPartialContent() && range != null && range.hasHeaders(RangeHeaders.RangeUnit.BYTES)) {
            return range.getTotal(RangeHeaders.RangeUnit.BYTES);
        }
        return container.getFileSize();
    }

    private Long getDeliveredStreamSize(HttpDeliveryContainer container) {
        RangeHeaders range = this.getResponseRangeHeader(container.getResponseHeaders());
        if (container.isPartialContent() && range != null && range.hasHeaders(RangeHeaders.RangeUnit.BYTES)) {
            return range.getEndAsLong(RangeHeaders.RangeUnit.BYTES) - range.getStartAsLong(RangeHeaders.RangeUnit.BYTES) + 1L;
        }
        return null;
    }

    private MediaType getMediaType(Map<String, Object> headers) {
        String contentType = this.getHeaderStringValue("Content-Type", headers);
        if (contentType != null) {
            return new MediaType(contentType);
        }
        return null;
    }

    private RangeHeaders parseRequestRangeHeaders(Map<String, String> headers, Request request) throws HttpResponseCodeException {
        String rangeHeader = headers.get("Range");
        String startSecond = this.getRequestQueryParam("start");
        try {
            return RangeHeaders.parseHttpRange(RangeHeaders.RangeDefinition.CDS, rangeHeader, startSecond);
        }
        catch (NumberFormatException e) {
            this.log.debug("Unsupported range request, sending back 400");
            throw new HttpResponseCodeException(400);
        }
    }
}

