/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory.rest.resources.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.restlet.data.Tag;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import org.serviio.config.Configuration;
import org.serviio.library.entities.AccessGroup;
import org.serviio.library.local.LibraryManager;
import org.serviio.library.local.OnlineDBIdentifier;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.profile.DeliveryQuality;
import org.serviio.profile.Profile;
import org.serviio.profile.ProfileManager;
import org.serviio.restlet.HttpCodeException;
import org.serviio.restlet.ValidationException;
import org.serviio.upnp.service.contentdirectory.BrowseItemsHolder;
import org.serviio.upnp.service.contentdirectory.ContentDirectoryEngine;
import org.serviio.upnp.service.contentdirectory.InvalidBrowseFlagException;
import org.serviio.upnp.service.contentdirectory.ObjectNotFoundException;
import org.serviio.upnp.service.contentdirectory.ObjectType;
import org.serviio.upnp.service.contentdirectory.classes.AudioItem;
import org.serviio.upnp.service.contentdirectory.classes.Container;
import org.serviio.upnp.service.contentdirectory.classes.DirectoryObject;
import org.serviio.upnp.service.contentdirectory.classes.ImageItem;
import org.serviio.upnp.service.contentdirectory.classes.Item;
import org.serviio.upnp.service.contentdirectory.classes.MusicTrack;
import org.serviio.upnp.service.contentdirectory.classes.Resource;
import org.serviio.upnp.service.contentdirectory.classes.VideoItem;
import org.serviio.upnp.service.contentdirectory.rest.representation.AbstractCDSObjectRepresentation;
import org.serviio.upnp.service.contentdirectory.rest.representation.BrowseContentDirectoryRepresentation;
import org.serviio.upnp.service.contentdirectory.rest.representation.ContentURLRepresentation;
import org.serviio.upnp.service.contentdirectory.rest.representation.DirectoryObjectRepresentation;
import org.serviio.upnp.service.contentdirectory.rest.representation.OnlineIdentifierRepresentation;
import org.serviio.upnp.service.contentdirectory.rest.resources.CDSBrowseResource;
import org.serviio.upnp.service.contentdirectory.rest.resources.server.AbstractRestrictedCDSServerResource;
import org.serviio.util.HttpUtils;
import org.serviio.util.StringUtils;

public class CDSBrowseServerResource
extends AbstractRestrictedCDSServerResource
implements CDSBrowseResource {
    private String profileId;
    private String objectId;
    private int startIndex;
    private int count;
    private String browseFlag;
    private ObjectType objectType = ObjectType.ALL;
    private boolean ignorePresentationSettings;

    @Override
    public BrowseContentDirectoryRepresentation browse() {
        Profile rendererProfile = ProfileManager.getProfileById(this.profileId);
        if (rendererProfile == null) {
            this.log.warn(String.format("Profile with id %s doesn't exist", this.profileId));
            throw new HttpCodeException(400);
        }
        try {
            ContentDirectoryEngine engine = ContentDirectoryEngine.getInstance();
            BrowseItemsHolder<DirectoryObject> itemsHolder = engine.browse(this.objectId, this.objectType, this.browseFlag, "*", this.startIndex, this.count, "", ProfileManager.getProfileById(this.profileId), AccessGroup.ANY, this.ignorePresentationSettings);
            return this.buildResult(itemsHolder);
        }
        catch (ObjectNotFoundException e) {
            this.log.warn(String.format("Object with id %s doesn't exist", this.objectId));
            throw new HttpCodeException(404);
        }
        catch (InvalidBrowseFlagException e) {
            this.log.warn(e.getMessage());
            throw new ValidationException(700);
        }
        catch (Exception e) {
            this.log.warn(String.format("Browse for object id %s failed with exception: %s", this.objectId, e.getMessage()), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.objectId = HttpUtils.urlDecode((String)this.getRequestAttributes().get("objectId"));
        this.browseFlag = (String)this.getRequestAttributes().get("browseFlag");
        this.startIndex = Integer.parseInt((String)this.getRequestAttributes().get("start"));
        this.count = Integer.parseInt((String)this.getRequestAttributes().get("count"));
        this.objectType = ObjectType.valueOf(StringUtils.localeSafeToUppercase((String)this.getRequestAttributes().get("objectType")));
        this.profileId = (String)this.getRequestAttributes().get("profile");
        this.ignorePresentationSettings = Boolean.valueOf(this.getRequestQueryParam("ignorePresentationSettings"));
    }

    public Representation handle() {
        Representation rep = super.handle();
        if (rep != null) {
            rep.setTag(new Tag(LibraryManager.getInstance().getUpdateId(this.getFileType()).toString(), true));
        }
        return rep;
    }

    private MediaFileType getFileType() {
        if (this.objectId.startsWith("A")) {
            return MediaFileType.AUDIO;
        }
        if (this.objectId.startsWith("I")) {
            return MediaFileType.IMAGE;
        }
        return MediaFileType.VIDEO;
    }

    private BrowseContentDirectoryRepresentation buildResult(BrowseItemsHolder<DirectoryObject> itemsHolder) {
        BrowseContentDirectoryRepresentation result = new BrowseContentDirectoryRepresentation();
        ArrayList<DirectoryObjectRepresentation> objects = new ArrayList<DirectoryObjectRepresentation>();
        for (DirectoryObject dirObject : itemsHolder.getItems()) {
            AbstractCDSObjectRepresentation.DirectoryObjectType type = dirObject instanceof Container ? AbstractCDSObjectRepresentation.DirectoryObjectType.CONTAINER : AbstractCDSObjectRepresentation.DirectoryObjectType.ITEM;
            DirectoryObjectRepresentation objRep = new DirectoryObjectRepresentation(type, dirObject.getTitle(), dirObject.getId());
            objRep.setParentId(dirObject.getParentID());
            if (objRep.getType() == AbstractCDSObjectRepresentation.DirectoryObjectType.CONTAINER) {
                Container container = (Container)dirObject;
                objRep.setChildCount(container.getChildCount());
                objRep.setThumbnailUrl(this.getResourceUrl(container.getIcon(), this.profileId));
            } else {
                Item item = (Item)dirObject;
                List<Resource> resources = this.getSuitableResources(item);
                if (resources.size() > 0) {
                    Resource defaultQualityResource = resources.get(0);
                    objRep.setThumbnailUrl(this.getResourceUrl(item.getIcon(), this.profileId));
                    this.storeContentUrls(objRep, resources);
                    if (item instanceof AudioItem) {
                        AudioItem audioItem = (AudioItem)item;
                        objRep.setFileType(MediaFileType.AUDIO);
                        objRep.setDescription(audioItem.getDescription());
                        objRep.setGenre(audioItem.getGenre());
                        objRep.setLive(audioItem.getLive());
                        if (audioItem instanceof MusicTrack) {
                            MusicTrack musicTrack = (MusicTrack)audioItem;
                            objRep.setDate(musicTrack.getDate());
                            objRep.setOriginalTrackNumber(musicTrack.getOriginalTrackNumber());
                            objRep.setArtist(this.getFirstItemFromArray(musicTrack.getArtist()));
                            objRep.setAlbum(musicTrack.getAlbum());
                            objRep.setDuration(defaultQualityResource.getDuration());
                        }
                    } else if (item instanceof VideoItem) {
                        VideoItem videoItem = (VideoItem)item;
                        objRep.setFileType(MediaFileType.VIDEO);
                        objRep.setDescription(videoItem.getDescription());
                        objRep.setGenre(videoItem.getGenre());
                        objRep.setDate(videoItem.getDate());
                        objRep.setDuration(defaultQualityResource.getDuration());
                        objRep.setSubtitlesUrl(this.getResourceUrl(videoItem.getSubtitlesUrlResource(), this.profileId));
                        objRep.setLive(videoItem.getLive());
                        objRep.setContentType(videoItem.getContentType());
                        objRep.setRating(videoItem.getRating());
                        this.storeOnlineIdentifiers(objRep, videoItem);
                    } else if (item instanceof ImageItem) {
                        ImageItem imageItem = (ImageItem)item;
                        objRep.setFileType(MediaFileType.IMAGE);
                        objRep.setDescription(imageItem.getDescription());
                        objRep.setDate(imageItem.getDate());
                    }
                }
            }
            objects.add(objRep);
        }
        result.setObjects(objects);
        result.setReturnedSize(itemsHolder.getReturnedSize());
        result.setTotalMatched(itemsHolder.getTotalMatched());
        return result;
    }

    private void storeContentUrls(DirectoryObjectRepresentation objRep, List<Resource> resources) {
        ArrayList<ContentURLRepresentation> urls = new ArrayList<ContentURLRepresentation>();
        DeliveryQuality.QualityType preferredQualityType = this.findPreferredQualityType(resources);
        boolean defaultQualityApplied = false;
        for (Resource resource : resources) {
            ContentURLRepresentation urlRepresentation = new ContentURLRepresentation(resource.getQuality(), this.getResourceUrl(resource, this.profileId));
            urlRepresentation.setResolution(resource.getResolution());
            urlRepresentation.setTranscoded(resource.isTranscoded());
            urlRepresentation.setFileSize(resource.getSize());
            if (!defaultQualityApplied && resource.getQuality() == preferredQualityType) {
                urlRepresentation.setPreferred(true);
                defaultQualityApplied = true;
            }
            urls.add(urlRepresentation);
        }
        objRep.setContentUrls(urls);
    }

    private void storeOnlineIdentifiers(DirectoryObjectRepresentation objRep, VideoItem videoItem) {
        if (videoItem.getOnlineIdentifiers() != null && videoItem.getOnlineIdentifiers().size() > 0) {
            ArrayList<OnlineIdentifierRepresentation> reps = new ArrayList<OnlineIdentifierRepresentation>();
            for (Map.Entry<OnlineDBIdentifier, String> entry : videoItem.getOnlineIdentifiers().entrySet()) {
                reps.add(new OnlineIdentifierRepresentation(entry.getKey().toString(), entry.getValue()));
            }
            objRep.setOnlineIdentifiers(reps);
        }
    }

    private DeliveryQuality.QualityType findPreferredQualityType(List<Resource> resources) {
        DeliveryQuality.QualityType preferredQuality = Configuration.getRemotePreferredDeliveryQuality();
        Set<DeliveryQuality.QualityType> availableQualities = this.getResourceQualities(resources);
        if (availableQualities.contains((Object)preferredQuality)) {
            return preferredQuality;
        }
        if (preferredQuality == DeliveryQuality.QualityType.LOW) {
            return this.findAlternativeQuality(availableQualities, DeliveryQuality.QualityType.MEDIUM, DeliveryQuality.QualityType.ORIGINAL);
        }
        if (preferredQuality == DeliveryQuality.QualityType.MEDIUM) {
            return this.findAlternativeQuality(availableQualities, DeliveryQuality.QualityType.LOW, DeliveryQuality.QualityType.ORIGINAL);
        }
        return this.findAlternativeQuality(availableQualities, DeliveryQuality.QualityType.MEDIUM, DeliveryQuality.QualityType.LOW);
    }

    private DeliveryQuality.QualityType findAlternativeQuality(Set<DeliveryQuality.QualityType> availableQualities, DeliveryQuality.QualityType firstChoice, DeliveryQuality.QualityType fallbackChoice) {
        if (availableQualities.contains((Object)firstChoice)) {
            return firstChoice;
        }
        return fallbackChoice;
    }

    private Set<DeliveryQuality.QualityType> getResourceQualities(List<Resource> resources) {
        HashSet<DeliveryQuality.QualityType> qualities = new HashSet<DeliveryQuality.QualityType>();
        for (Resource res : resources) {
            qualities.add(res.getQuality());
        }
        return qualities;
    }

    private String getFirstItemFromArray(String[] array) {
        if (array != null && array.length > 0) {
            return array[0];
        }
        return null;
    }

    private List<Resource> getSuitableResources(Item item) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (Resource res : item.getResources()) {
            if (res.getResourceType() != Resource.ResourceType.MEDIA_ITEM && res.getResourceType() != Resource.ResourceType.MANIFEST || res.getProtocolInfoIndex() != 0) continue;
            resources.add(res);
        }
        Collections.sort(resources, new ResourceComparator());
        HashSet<DeliveryQuality.QualityType> foundQualities = new HashSet<DeliveryQuality.QualityType>();
        Iterator it = resources.iterator();
        while (it.hasNext()) {
            Resource r = (Resource)it.next();
            if (foundQualities.contains((Object)r.getQuality())) {
                it.remove();
                continue;
            }
            foundQualities.add(r.getQuality());
        }
        return resources;
    }

    private class ResourceComparator
    implements Comparator<Resource> {
        private ResourceComparator() {
        }

        @Override
        public int compare(Resource o1, Resource o2) {
            if (o1.getQuality() == o2.getQuality()) {
                if (o1.getProtocolInfo().indexOf("CI=1") == -1) {
                    return -1;
                }
                return 1;
            }
            return new Integer(o1.getQuality().ordinal()).compareTo(new Integer(o2.getQuality().ordinal()));
        }
    }
}

