/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory.rest.resources.server;

import java.util.Arrays;
import java.util.Map;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.CacheDirective;
import org.restlet.data.Form;
import org.restlet.data.Method;
import org.restlet.data.Parameter;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import org.serviio.MediaServer;
import org.serviio.UPnPServerStatus;
import org.serviio.delivery.CDSUrlParameters;
import org.serviio.delivery.HostInfo;
import org.serviio.restlet.AbstractProEditionServerResource;
import org.serviio.restlet.ServerUnavailableException;
import org.serviio.upnp.service.contentdirectory.classes.InvalidResourceException;
import org.serviio.upnp.service.contentdirectory.classes.Resource;
import org.serviio.util.CaseInsensitiveMap;
import org.serviio.util.StringUtils;

public abstract class AbstractCDSServerResource
extends AbstractProEditionServerResource {
    private static final String ORG_RESTLET_HTTP_HEADERS = "org.restlet.http.headers";
    protected static final String X_SERVIIO_CLIENTID_HEADER = "X-Serviio-ClientId";

    protected void doInit() throws ResourceException {
        this.getResponse().setCacheDirectives(Arrays.asList(new CacheDirective("no-cache")));
    }

    @Override
    protected Representation doConditionalHandle() {
        if (MediaServer.getStatus() == UPnPServerStatus.STARTED) {
            Representation rep = super.doConditionalHandle();
            this.setOriginHeaders();
            return rep;
        }
        throw new ServerUnavailableException();
    }

    private void setOriginHeaders() {
        this.setCustomHeader(this.getResponse(), "Access-Control-Allow-Origin", "*");
        if (this.getRequest().getMethod().equals((Object)Method.OPTIONS)) {
            this.setCustomHeader(this.getResponse(), "Access-Control-Allow-Methods", "GET,POST,PUT,HEAD,OPTIONS");
            this.setCustomHeader(this.getResponse(), "Access-Control-Allow-Headers", "Content-Type");
        }
    }

    protected Map<String, String> getRequestHeaders(Request request) {
        Form form = (Form)request.getAttributes().get(ORG_RESTLET_HTTP_HEADERS);
        CaseInsensitiveMap<String> headers = new CaseInsensitiveMap<String>();
        for (Parameter p : form) {
            headers.put(p.getName(), p.getValue());
        }
        return headers;
    }

    protected void setCustomHeader(Response response, String name, String value) {
        Form form = (Form)response.getAttributes().get(ORG_RESTLET_HTTP_HEADERS);
        if (form == null) {
            form = new Form();
            response.getAttributes().put(ORG_RESTLET_HTTP_HEADERS, form);
        }
        form.add(name, value);
    }

    protected Object getHeaderValue(String headerName, Map<String, ?> headers) {
        String lowercaseHeaderName = StringUtils.localeSafeToLowercase(headerName);
        for (Map.Entry<String, ?> header : headers.entrySet()) {
            if (!lowercaseHeaderName.equals(StringUtils.localeSafeToLowercase(header.getKey()))) continue;
            return header.getValue();
        }
        return null;
    }

    protected String getHeaderStringValue(String headerName, Map<String, ?> headers) {
        Object value = this.getHeaderValue(headerName, headers);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    protected HostInfo getHostInfo(boolean includeHost, boolean withSharedAuthentication, String profileId) {
        String host = null;
        Integer port = null;
        if (includeHost) {
            host = this.getRequest().getHostRef().getHostDomain();
            port = this.getRequest().getHostRef().getHostPort();
        }
        return new HostInfo(host, port, "/cds/resource", new CDSUrlParameters(withSharedAuthentication, profileId));
    }

    protected String getResourceUrl(Resource resource, String profileId) {
        if (resource != null) {
            try {
                return resource.getGeneratedURL(this.getHostInfo(false, false, profileId));
            }
            catch (InvalidResourceException e) {
                this.log.warn("Cannot generate resource URL because the resource is invalid.");
            }
        }
        return null;
    }

    protected String getRequestQueryParam(String paramName) {
        return new Form(this.getRequest().getOriginalRef().getQuery(true)).getFirstValue(paramName, true);
    }
}

