/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory.rest.representation;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.engine.Edition;
import org.restlet.engine.io.BioUtils;
import org.restlet.representation.StreamRepresentation;
import org.serviio.util.FileUtils;

public class ClosingInputRepresentation
extends StreamRepresentation {
    private volatile InputStream stream;
    private Long deliveredSize;
    private Request request;

    public ClosingInputRepresentation(InputStream inputStream, Request request) {
        this(inputStream, null, request);
    }

    public ClosingInputRepresentation(InputStream inputStream, MediaType mediaType, Request request) {
        this(inputStream, mediaType, -1L, null, request);
    }

    public ClosingInputRepresentation(InputStream inputStream, MediaType mediaType, long expectedSize, Long deliveredSize, Request request) {
        super(mediaType);
        this.setSize(expectedSize);
        this.setTransient(true);
        this.setStream(inputStream);
        this.request = request;
        this.deliveredSize = deliveredSize;
    }

    public InputStream getStream() throws IOException {
        if (Edition.CURRENT != Edition.GWT) {
            InputStream result = this.stream;
            this.setStream(null);
            return result;
        }
        return this.stream;
    }

    public String getText() throws IOException {
        return BioUtils.toString((InputStream)this.getStream(), (CharacterSet)this.getCharacterSet());
    }

    public void release() {
        this.request.abort();
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (IOException e) {
                Context.getCurrentLogger().log(Level.WARNING, "Error while releasing the representation.", e);
            }
            this.stream = null;
        }
        super.release();
    }

    public void setStream(InputStream stream) {
        this.stream = stream;
        this.setAvailable(stream != null);
    }

    public void write(OutputStream outputStream) throws IOException {
        if (this.getSize() == -1L) {
            BioUtils.copy((InputStream)this.getStream(), (OutputStream)outputStream);
        } else if (this.deliveredSize == null) {
            BioUtils.copy((InputStream)this.getStream(), (OutputStream)outputStream);
        } else {
            FileUtils.copyStream(this.getStream(), outputStream, this.deliveredSize);
        }
    }
}

