/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory.rest.access;

import java.io.IOException;
import net.sbbi.upnp.impls.InternetGatewayDevice;
import net.sbbi.upnp.messages.UPNPResponseException;
import org.serviio.upnp.Device;
import org.serviio.upnp.service.contentdirectory.rest.access.PortMapper;
import org.serviio.upnp.service.contentdirectory.rest.access.WebGateway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UPnPWebGateway
implements WebGateway {
    private static final Logger log = LoggerFactory.getLogger(UPnPWebGateway.class);
    private static final int DISCOVERY_TIMEOUT = 3000;
    private final InternetGatewayDevice device;

    private UPnPWebGateway(InternetGatewayDevice device) {
        this.device = device;
    }

    public static UPnPWebGateway findRouter() throws Exception {
        try {
            InternetGatewayDevice[] devices = InternetGatewayDevice.getDevices((int)3000);
            if (devices != null && devices.length > 0) {
                InternetGatewayDevice device = devices[0];
                log.debug(String.format("Found a UPnP router device '%s'", device.getIGDRootDevice().getModelName()));
                return new UPnPWebGateway(devices[0]);
            }
            return null;
        }
        catch (IOException e) {
            throw new Exception(String.format("Could not find UPnP router because of an exception: %s", e.getMessage()), e);
        }
    }

    @Override
    public void addPortMapping(int externalPort, int internalPort, int leaseDuration) throws Exception {
        String localAddress = Device.getInstance().getBindAddress().getHostAddress();
        log.debug(String.format("Adding/updating router port mapping (%s -> %s) for IP %s with lease of %s sec.", externalPort, internalPort, localAddress, leaseDuration));
        try {
            this.invokeAddPortMapping(externalPort, internalPort, localAddress, leaseDuration);
        }
        catch (UPNPResponseException e) {
            int errorCode = e.getDetailErrorCode();
            if (errorCode == 725) {
                log.debug("Temporary lease rejected, trying permanent lease");
                this.invokeAddPortMapping(externalPort, internalPort, localAddress, 0);
                PortMapper.getInstance().shutdownLeaseRenewer();
                return;
            }
            throw e;
        }
    }

    @Override
    public void deletePortMapping(int externalPort, int internalPort) throws Exception {
        log.debug(String.format("Removing router port mapping (%s -> %s)", externalPort, internalPort));
        this.device.deletePortMapping(null, externalPort, "TCP");
    }

    private void invokeAddPortMapping(int externalPort, int internalPort, String localAddress, int leaseDuration) throws UPNPResponseException, IOException {
        this.device.addPortMapping("Serviio", null, internalPort, externalPort, localAddress, leaseDuration, "TCP");
    }
}

