/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory.rest.access;

import java.io.IOException;
import java.util.ArrayList;
import org.restlet.Client;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Form;
import org.restlet.data.Method;
import org.restlet.data.Parameter;
import org.restlet.data.Protocol;
import org.restlet.data.Status;
import org.serviio.upnp.service.contentdirectory.rest.access.ExternalIPRetriever;
import org.serviio.util.ObjectValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortMappingChecker {
    private static final String API_URL = "http://ports.yougetsignal.com/check-port.php";
    private static final Logger log = LoggerFactory.getLogger(PortMappingChecker.class);
    private static final Client c = new Client(Protocol.HTTP);

    public static synchronized boolean isPortOpen(String address, int port) throws IOException {
        String externalAddress = ObjectValidator.isEmpty(address) ? ExternalIPRetriever.getExternalIP().getHostAddress() : address;
        log.info(String.format("Running a check for external mapping of port %s on '%s'", port, externalAddress));
        ArrayList<Parameter> form = new ArrayList<Parameter>(2);
        form.add(new Parameter("remoteAddress", externalAddress));
        form.add(new Parameter("portNumber", Integer.toString(port)));
        Form webForm = new Form(form);
        try {
            String html;
            Request r = new Request(Method.POST, API_URL);
            r.setEntity(webForm.getWebRepresentation());
            Response res = c.handle(r);
            if (res.getStatus().equals((Object)Status.SUCCESS_OK) && (html = res.getEntityAsText()) != null) {
                if (html.indexOf("is closed") > -1) {
                    log.info(String.format("Port %s is closed", port));
                    return false;
                }
                if (html.indexOf("is open") > -1) {
                    log.info(String.format("Port %s is open", port));
                    return true;
                }
                log.warn(String.format("Cannot work out whether port %s is open or closed", port));
                return false;
            }
            throw new IOException("Returned response is empty");
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
    }
}

