/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory.rest.access;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.serviio.config.Configuration;
import org.serviio.licensing.LicensingManager;
import org.serviio.upnp.service.contentdirectory.rest.access.NATPMPGateway;
import org.serviio.upnp.service.contentdirectory.rest.access.UPnPWebGateway;
import org.serviio.upnp.service.contentdirectory.rest.access.WebGateway;
import org.serviio.util.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortMapper {
    private static final Logger log = LoggerFactory.getLogger(PortMapper.class);
    private static PortMapper instance;
    private static final int LEASE_DURATION = 1800;
    private ScheduledExecutorService leaseRenewalExecutor;
    private final Runnable renewer = new PortmappingLeaseRenewer();
    private WebGateway router;

    private PortMapper() {
        if (this.isPortMappingEnabled()) {
            this.startLeaserRenewer();
        }
    }

    public static PortMapper getInstance() {
        if (instance == null) {
            instance = new PortMapper();
        }
        return instance;
    }

    public void addPortMapping() {
        if (this.isPortMappingEnabled()) {
            ThreadUtils.runAsynchronously(new Runnable(){

                @Override
                public void run() {
                    WebGateway router = PortMapper.this.getRouter();
                    if (router != null) {
                        try {
                            router.addPortMapping(23424, 23424, 1800);
                        }
                        catch (Exception e) {
                            log.warn(String.format("Could not add port mapping to the router: %s", e.getMessage()));
                        }
                    }
                }
            });
        }
    }

    public void removePortMapping() {
        ThreadUtils.runAsynchronously(new Runnable(){

            @Override
            public void run() {
                if (PortMapper.this.router != null) {
                    try {
                        PortMapper.this.router.deletePortMapping(23424, 23424);
                    }
                    catch (Exception e) {
                        log.warn(String.format("Could not remove port mapping from the router: %s", e.getMessage()));
                    }
                }
            }
        });
    }

    public void resetPortMapping() {
        if (this.isPortMappingEnabled()) {
            ThreadUtils.runAsynchronously(new Runnable(){

                @Override
                public void run() {
                    WebGateway router = PortMapper.this.findRouter();
                    if (router != null) {
                        try {
                            router.deletePortMapping(23424, 23424);
                            router.addPortMapping(23424, 23424, 1800);
                        }
                        catch (Exception e) {
                            log.warn(String.format("Could not reset port mapping to the router: %s", e.getMessage()), (Throwable)e);
                        }
                    }
                }
            });
        }
    }

    public void shutdownLeaseRenewer() {
        if (this.leaseRenewalExecutor != null && !this.leaseRenewalExecutor.isShutdown()) {
            log.info("Stopping port mapping scheduler");
            this.leaseRenewalExecutor.shutdown();
            this.leaseRenewalExecutor = null;
        }
    }

    public void startLeaserRenewer() {
        log.info("Starting port mapping scheduler");
        if (this.leaseRenewalExecutor == null) {
            this.leaseRenewalExecutor = Executors.newScheduledThreadPool(1);
            this.leaseRenewalExecutor.scheduleWithFixedDelay(this.renewer, 600L, 600L, TimeUnit.SECONDS);
        }
    }

    private boolean isPortMappingEnabled() {
        return LicensingManager.getInstance().isProVersion() && Configuration.isRemotePortForwardingEnabled();
    }

    private WebGateway findRouter() {
        WebGateway router = null;
        try {
            router = UPnPWebGateway.findRouter();
        }
        catch (Throwable e) {
            log.debug(e.getMessage());
        }
        if (router == null) {
            try {
                router = NATPMPGateway.findRouter();
            }
            catch (Throwable e) {
                log.debug(e.getMessage());
            }
        }
        if (router == null) {
            log.warn("Could not find a router on the network. Autodiscovery (UPnP/NAP PMP) might be disabled or the router is not currently supported.");
        }
        return router;
    }

    private WebGateway getRouter() {
        if (this.router == null) {
            this.router = this.findRouter();
        }
        return this.router;
    }

    private class PortmappingLeaseRenewer
    implements Runnable {
        private PortmappingLeaseRenewer() {
        }

        @Override
        public void run() {
            log.debug("Renewing port mapping lease");
            PortMapper.this.addPortMapping();
        }
    }
}

