/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory.rest.access;

import com.hoodcomputing.natpmp.MapRequestMessage;
import com.hoodcomputing.natpmp.Message;
import com.hoodcomputing.natpmp.NatPmpDevice;
import org.serviio.upnp.service.contentdirectory.rest.access.WebGateway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NATPMPGateway
implements WebGateway {
    private static final Logger log = LoggerFactory.getLogger(NATPMPGateway.class);
    private final NatPmpDevice device;

    private NATPMPGateway(NatPmpDevice device) {
        this.device = device;
    }

    public static NATPMPGateway findRouter() throws Exception {
        return new NATPMPGateway(new NatPmpDevice(false));
    }

    @Override
    public void addPortMapping(int externalPort, int internalPort, int leaseDuration) throws Exception {
        log.debug(String.format("Adding/updating router port mapping (%s -> %s) with lease of %s sec.", externalPort, internalPort, leaseDuration));
        MapRequestMessage map = new MapRequestMessage(true, internalPort, externalPort, (long)leaseDuration, null);
        this.device.enqueueMessage((Message)map);
        this.device.waitUntilQueueEmpty();
    }

    @Override
    public void deletePortMapping(int externalPort, int internalPort) throws Exception {
        log.debug(String.format("Removing router port mapping (%s -> %s)", externalPort, internalPort));
        MapRequestMessage map = new MapRequestMessage(true, internalPort, externalPort, 0L, null);
        this.device.enqueueMessage((Message)map);
        this.device.waitUntilQueueEmpty();
    }
}

