/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory.definition.i18n;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.serviio.config.Configuration;
import org.serviio.i18n.GetLocalizationMessageBundleControl;
import org.serviio.i18n.Language;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowsingCategoriesMessages {
    private static final Logger log = LoggerFactory.getLogger(BrowsingCategoriesMessages.class);
    private static ResourceBundle selectedRb;
    private static ResourceBundle defaultRb;
    private static Locale defaultLocale;
    private static final String BUNDLE = "org.serviio.upnp.service.contentdirectory.definition.i18n.browsingCategories";
    private static ResourceBundle.Control control;

    public static String getMessage(String key, Object ... args) {
        if (selectedRb == null) {
            BrowsingCategoriesMessages.loadLocale(defaultLocale);
        }
        String result = null;
        try {
            result = MessageFormat.format(selectedRb.getString(key), args);
        }
        catch (MissingResourceException e) {
            result = MessageFormat.format(defaultRb.getString(key), args);
        }
        return result;
    }

    public static void loadLocale(Locale locale) {
        selectedRb = ResourceBundle.getBundle(BUNDLE, locale, control);
        log.info(String.format("Loaded browsing categories message bundle for locale: %s", locale.toString()));
    }

    static {
        defaultLocale = Locale.ENGLISH;
        control = new GetLocalizationMessageBundleControl();
        defaultRb = ResourceBundle.getBundle(BUNDLE, defaultLocale, control);
        BrowsingCategoriesMessages.loadLocale(Language.getLocale(Configuration.getBrowseMenuPreferredLanguage()));
    }
}

