/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory.definition;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.serviio.library.entities.AccessGroup;
import org.serviio.profile.Profile;
import org.serviio.upnp.service.contentdirectory.ObjectType;
import org.serviio.upnp.service.contentdirectory.classes.ClassProperties;
import org.serviio.upnp.service.contentdirectory.classes.DirectoryObject;
import org.serviio.upnp.service.contentdirectory.classes.DirectoryObjectBuilder;
import org.serviio.upnp.service.contentdirectory.classes.ObjectClassType;
import org.serviio.upnp.service.contentdirectory.definition.ContainerNode;
import org.serviio.upnp.service.contentdirectory.definition.ContentDirectoryDefinitionException;
import org.serviio.upnp.service.contentdirectory.definition.ContentDirectoryDefinitionFilter;
import org.serviio.upnp.service.contentdirectory.definition.Definition;
import org.serviio.upnp.service.contentdirectory.definition.DefinitionNode;
import org.serviio.upnp.service.contentdirectory.definition.StaticDefinitionNode;
import org.serviio.upnp.service.contentdirectory.definition.i18n.BrowsingCategoriesMessages;
import org.serviio.util.ObjectValidator;

public class StaticContainerNode
extends ContainerNode
implements StaticDefinitionNode {
    private static final Set<ObjectClassType> supportedClasses = new HashSet<ObjectClassType>(Arrays.asList(ObjectClassType.CONTAINER, ObjectClassType.STORAGE_FOLDER));
    private String id;
    private String titleKey;
    private boolean browsable = true;
    private boolean editable = false;

    public StaticContainerNode(String id, String titleKey, ObjectClassType objectClass, DefinitionNode parent, String cacheRegion) {
        super(objectClass, parent, cacheRegion);
        this.id = id;
        this.titleKey = titleKey;
    }

    @Override
    public DirectoryObject retrieveDirectoryObject(String objectId, ObjectType objectType, Profile rendererProfile, AccessGroup userProfile, boolean disablePresentationSettings) {
        HashMap<ClassProperties, Object> values = new HashMap<ClassProperties, Object>();
        values.put(ClassProperties.ID, this.getId());
        values.put(ClassProperties.TITLE, this.getBrowsableTitle(disablePresentationSettings));
        values.put(ClassProperties.CHILD_COUNT, this.retrieveContainerItemsCount(objectId, objectType, null, userProfile, disablePresentationSettings));
        values.put(ClassProperties.PARENT_ID, Definition.instance().getParentNodeId(objectId, disablePresentationSettings));
        values.put(ClassProperties.SEARCHABLE, Boolean.FALSE);
        ObjectClassType containerClassType = this.containerClass;
        ContentDirectoryDefinitionFilter definitionFilter = rendererProfile.getContentDirectoryDefinitionFilter();
        if (definitionFilter != null) {
            definitionFilter.filterClassProperties(objectId, values);
            containerClassType = definitionFilter.filterContainerClassType(containerClassType, objectId);
        }
        return DirectoryObjectBuilder.createInstance(containerClassType, values, null, null, disablePresentationSettings);
    }

    @Override
    public void validate() throws ContentDirectoryDefinitionException {
        super.validate();
        if (ObjectValidator.isEmpty(this.id)) {
            throw new ContentDirectoryDefinitionException("Node ID not provided.");
        }
        if (ObjectValidator.isEmpty(this.titleKey)) {
            throw new ContentDirectoryDefinitionException("Node Title not provided.");
        }
        if (!supportedClasses.contains((Object)this.containerClass)) {
            throw new ContentDirectoryDefinitionException("Unsupported container class.");
        }
        if (ObjectValidator.isEmpty(this.cacheRegion)) {
            throw new ContentDirectoryDefinitionException("Node CacheRegion not provided.");
        }
    }

    private String getBrowsableTitle(boolean disablePresentationSettings) {
        String parentsTitle = Definition.instance().getContentOnlyParentTitles(this.id, disablePresentationSettings);
        if (parentsTitle != null) {
            return String.format("%s %s", this.getTitle(), parentsTitle);
        }
        return this.getTitle();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getTitle() {
        return BrowsingCategoriesMessages.getMessage(this.titleKey, new Object[0]);
    }

    public boolean isBrowsable() {
        return this.browsable;
    }

    public void setBrowsable(boolean visible) {
        this.browsable = visible;
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public void setEditable(boolean editable) {
        this.editable = editable;
    }
}

