/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory.definition;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.serviio.config.Configuration;
import org.serviio.library.search.SearchIndexer;
import org.serviio.upnp.service.contentdirectory.definition.ActionNode;
import org.serviio.upnp.service.contentdirectory.definition.ContainerNode;
import org.serviio.upnp.service.contentdirectory.definition.ContainerVisibilityType;
import org.serviio.upnp.service.contentdirectory.definition.ContentDirectoryDefinitionException;
import org.serviio.upnp.service.contentdirectory.definition.ContentDirectoryDefinitionParser;
import org.serviio.upnp.service.contentdirectory.definition.DefinitionNode;
import org.serviio.upnp.service.contentdirectory.definition.StaticContainerNode;
import org.serviio.upnp.service.contentdirectory.definition.StaticDefinitionNode;
import org.serviio.util.CollectionUtils;

public class Definition {
    public static final String ROOT_NODE_ID = "0";
    public static final String ROOT_NODE_PARENT_ID = "-1";
    public static final String NODE_ID_VIDEO = "V";
    public static final String NODE_ID_IMAGE = "I";
    public static final String NODE_ID_AUDIO = "A";
    public static final String SEGMENT_SEPARATOR = "^";
    private static final String SEGMENT_SEPARATOR_REGEX = "\\^";
    private static Definition instance;
    private ContainerNode rootNode;

    public Definition(ContainerNode rootNode) {
        this.rootNode = rootNode;
    }

    public static Definition instance() {
        if (instance == null) {
            InputStream definitionStream = Definition.class.getResourceAsStream("contentDirectoryDef.xml");
            try {
                instance = ContentDirectoryDefinitionParser.parseDefinition(definitionStream);
            }
            catch (ContentDirectoryDefinitionException e) {
                throw new RuntimeException(String.format("Cannot initialize ContentDirectory service: %s", e.getMessage()), e);
            }
        }
        return instance;
    }

    public static void setInstance(Definition instance) {
        Definition.instance = instance;
    }

    public static void reload() {
        Definition.setInstance(null);
    }

    public ContainerNode getContainer(String nodeId) {
        String[] idSegments = nodeId.split(SEGMENT_SEPARATOR_REGEX);
        ContainerNode staticNode = this.findStaticContainer(idSegments[0], this.rootNode);
        if (idSegments.length == 1) {
            return staticNode;
        }
        if (idSegments.length > 1) {
            ContainerNode contextNode = staticNode;
            for (int i = 1; !(i >= idSegments.length || contextNode == null || contextNode != null && contextNode instanceof ActionNode && ((ActionNode)contextNode).isRecursive()); ++i) {
                contextNode = this.findActionContainer(idSegments[i], contextNode);
            }
            return contextNode;
        }
        return null;
    }

    public String getParentNodeId(String objectId, boolean disablePresentationSettings) {
        String[] idSegments = objectId.split(SEGMENT_SEPARATOR_REGEX);
        if (idSegments.length == 1) {
            ContainerNode staticNode = this.findStaticContainer(idSegments[0], this.rootNode);
            if (staticNode == null || staticNode.getParent() == null) {
                return ROOT_NODE_PARENT_ID;
            }
            StaticContainerNode parent = (StaticContainerNode)staticNode.getParent();
            if (this.isEnabledContainer(parent.getId(), disablePresentationSettings)) {
                return parent.getId();
            }
            return this.getParentNodeId(parent.getId(), disablePresentationSettings);
        }
        String parentId = objectId.substring(0, objectId.indexOf(idSegments[idSegments.length - 1]) - 1);
        if (!parentId.contains(SEGMENT_SEPARATOR)) {
            if (this.isEnabledContainer(parentId, disablePresentationSettings)) {
                return parentId;
            }
            return this.getParentNodeId(parentId, disablePresentationSettings);
        }
        return parentId;
    }

    public boolean isEnabledContainer(String objectId, boolean disablePresentationSettings) {
        return this.getContainerVisibility(objectId, disablePresentationSettings) == ContainerVisibilityType.DISPLAYED;
    }

    public boolean isOnlyShowContentsOfContainer(String objectId, boolean disablePresentationSettings) {
        return this.getContainerVisibility(objectId, disablePresentationSettings) == ContainerVisibilityType.CONTENT_DISPLAYED;
    }

    public boolean isDisabledContainer(String objectId, boolean disablePresentationSettings) {
        return this.getContainerVisibility(objectId, disablePresentationSettings) == ContainerVisibilityType.DISABLED;
    }

    public ContainerVisibilityType getContainerVisibility(String objectId, boolean disablePresentationSettings) {
        if (disablePresentationSettings) {
            return ContainerVisibilityType.DISPLAYED;
        }
        Map<String, String> itemDef = Configuration.getBrowseMenuItemOptions();
        if (!itemDef.containsKey(objectId)) {
            return ContainerVisibilityType.DISPLAYED;
        }
        return ContainerVisibilityType.valueOf(itemDef.get(objectId));
    }

    public String getContentOnlyParentTitles(String objectId, boolean disablePresentationSettings) {
        if (Configuration.isBrowseMenuShowNameOfParentCategory()) {
            if (objectId.contains("$")) {
                return null;
            }
            ArrayList<String> parentTitles = new ArrayList<String>();
            Definition def = Definition.instance();
            ContainerNode object = this.getContainer(objectId);
            if (object != null) {
                for (DefinitionNode parentNode = object.getParent(); parentNode != null && parentNode instanceof StaticContainerNode && def.isOnlyShowContentsOfContainer(((StaticContainerNode)parentNode).getId(), disablePresentationSettings); parentNode = parentNode.getParent()) {
                    parentTitles.add(((StaticContainerNode)parentNode).getTitle());
                }
                if (parentTitles.size() > 0) {
                    Collections.reverse(parentTitles);
                    String parentsTitle = String.format("[%s]", CollectionUtils.listToCSV(parentTitles, "/", true));
                    return parentsTitle;
                }
            }
        }
        return null;
    }

    public List<ActionNode> findNodesForSearchCategory(SearchIndexer.SearchCategory category) {
        List<ActionNode> actionNodes = this.collectCommandsForSearchCategory(this.rootNode, category);
        return actionNodes;
    }

    private ContainerNode findStaticContainer(String nodeId, ContainerNode node) {
        if (node instanceof StaticContainerNode) {
            if (((StaticDefinitionNode)((Object)node)).getId().equals(nodeId)) {
                return node;
            }
            for (DefinitionNode childNode : node.getChildNodes()) {
                ContainerNode foundNode;
                if (!(childNode instanceof ContainerNode) || (foundNode = this.findStaticContainer(nodeId, (ContainerNode)childNode)) == null) continue;
                return foundNode;
            }
        }
        return null;
    }

    private ActionNode findActionContainer(String nodeIdElement, ContainerNode node) {
        for (DefinitionNode childNode : node.getChildNodes()) {
            ActionNode actionNode;
            if (!(childNode instanceof ActionNode) || !nodeIdElement.startsWith((actionNode = (ActionNode)childNode).getIdPrefix())) continue;
            return actionNode;
        }
        return null;
    }

    private List<ActionNode> collectCommandsForSearchCategory(ContainerNode root, SearchIndexer.SearchCategory category) {
        ArrayList<ActionNode> results = new ArrayList<ActionNode>();
        for (DefinitionNode node : root.getChildNodes()) {
            ActionNode an;
            if (node instanceof ActionNode && (an = (ActionNode)node).getSearchCategories() != null && an.getSearchCategories().contains((Object)category)) {
                results.add(an);
            }
            if (!(node instanceof ContainerNode)) continue;
            results.addAll(this.collectCommandsForSearchCategory((ContainerNode)node, category));
        }
        return results;
    }
}

